/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5.util;

import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteDumperExtension {
    private static final Logger LOG = LoggerFactory.getLogger(RouteDumperExtension.class);
    private final ModelCamelContext context;

    public RouteDumperExtension(ModelCamelContext context) {
        this.context = context;
    }

    public void dumpRoute(Class<?> testClass, String currentTestName, String format) throws Exception {
        LOG.debug("Dumping Route");
        String className = testClass.getSimpleName();
        String dir = "target/camel-route-dump";
        String name = className + "-" + StringHelper.before((String)currentTestName, (String)"(") + "." + format;
        DumpRoutesStrategy drs = (DumpRoutesStrategy)this.context.getCamelContextExtension().getContextPlugin(DumpRoutesStrategy.class);
        drs.setOutput(dir + "/" + name);
        drs.setInclude("*");
        drs.setLog(false);
        drs.setUriAsParameters(true);
        drs.dumpRoutes(format);
    }
}

