/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.DebugBreakpoint;

public class CamelContextConfiguration {
    private String routeFilterIncludePattern;
    private String routeFilterExcludePattern;
    private Registry registry;
    private Breakpoint breakpoint;
    private String mockEndpoints;
    private String mockEndpointsAndSkip;
    private String stubEndpoints;
    private String autoStartupExcludePatterns;
    private Properties useOverridePropertiesWithPropertiesComponent;
    private Boolean ignoreMissingLocationWithPropertiesComponent;
    private CamelContextSupplier camelContextSupplier;
    private RegistryBinder registryBinder;
    private Service camelContextService;
    private int shutdownTimeout = 10;
    private RoutesSupplier routesSupplier;
    private final Map<String, String> fromEndpoints = new HashMap<String, String>();
    private PostProcessor postProcessor;

    public String routeFilterIncludePattern() {
        return this.routeFilterIncludePattern;
    }

    public CamelContextConfiguration withRouteFilterIncludePattern(String routeFilterIncludePattern) {
        this.routeFilterIncludePattern = routeFilterIncludePattern;
        return this;
    }

    public String routeFilterExcludePattern() {
        return this.routeFilterExcludePattern;
    }

    public CamelContextConfiguration withRouteFilterExcludePattern(String routeFilterExcludePattern) {
        this.routeFilterExcludePattern = routeFilterExcludePattern;
        return this;
    }

    public Registry registry() {
        return this.registry;
    }

    public CamelContextConfiguration withRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public boolean useDebugger() {
        return this.breakpoint != null;
    }

    public Breakpoint breakpoint() {
        return this.breakpoint;
    }

    public CamelContextConfiguration withBreakpoint(DebugBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
        return this;
    }

    public String mockEndpoints() {
        return this.mockEndpoints;
    }

    public CamelContextConfiguration withMockEndpoints(String mockEndpoints) {
        this.mockEndpoints = mockEndpoints;
        return this;
    }

    public String mockEndpointsAndSkip() {
        return this.mockEndpointsAndSkip;
    }

    public CamelContextConfiguration withMockEndpointsAndSkip(String mockEndpointsAndSkip) {
        this.mockEndpointsAndSkip = mockEndpointsAndSkip;
        return this;
    }

    public String stubEndpoints() {
        return this.stubEndpoints;
    }

    public CamelContextConfiguration withStubEndpoints(String pattern) {
        this.stubEndpoints = pattern;
        return this;
    }

    public String autoStartupExcludePatterns() {
        return this.autoStartupExcludePatterns;
    }

    public CamelContextConfiguration withAutoStartupExcludePatterns(String pattern) {
        this.autoStartupExcludePatterns = pattern;
        return this;
    }

    public Properties useOverridePropertiesWithPropertiesComponent() {
        return this.useOverridePropertiesWithPropertiesComponent;
    }

    public CamelContextConfiguration withUseOverridePropertiesWithPropertiesComponent(Properties useOverridePropertiesWithPropertiesComponent) {
        this.useOverridePropertiesWithPropertiesComponent = useOverridePropertiesWithPropertiesComponent;
        return this;
    }

    public Boolean ignoreMissingLocationWithPropertiesComponent() {
        return this.ignoreMissingLocationWithPropertiesComponent;
    }

    public CamelContextConfiguration withIgnoreMissingLocationWithPropertiesComponent(Boolean ignoreMissingLocationWithPropertiesComponent) {
        this.ignoreMissingLocationWithPropertiesComponent = ignoreMissingLocationWithPropertiesComponent;
        return this;
    }

    public CamelContextSupplier camelContextSupplier() {
        return this.camelContextSupplier;
    }

    public CamelContextConfiguration withCamelContextSupplier(CamelContextSupplier camelContextSupplier) {
        this.camelContextSupplier = camelContextSupplier;
        return this;
    }

    public RegistryBinder registryBinder() {
        return this.registryBinder;
    }

    public CamelContextConfiguration withRegistryBinder(RegistryBinder registryBinder) {
        this.registryBinder = registryBinder;
        return this;
    }

    public int shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public CamelContextConfiguration withShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public Service camelContextService() {
        return this.camelContextService;
    }

    public CamelContextConfiguration withCamelContextService(Service camelContextService) {
        this.camelContextService = camelContextService;
        return this;
    }

    public RoutesSupplier routesSupplier() {
        return this.routesSupplier;
    }

    protected CamelContextConfiguration withRoutesSupplier(RoutesSupplier routesSupplier) {
        this.routesSupplier = routesSupplier;
        return this;
    }

    public Map<String, String> fromEndpoints() {
        return this.fromEndpoints;
    }

    void replaceRouteFromWith(String routeId, String fromEndpoint) {
        this.fromEndpoints.put(routeId, fromEndpoint);
    }

    public PostProcessor postProcessor() {
        return this.postProcessor;
    }

    protected CamelContextConfiguration withPostProcessor(PostProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    @FunctionalInterface
    public static interface CamelContextSupplier {
        public CamelContext createCamelContext() throws Exception;
    }

    @FunctionalInterface
    public static interface RegistryBinder {
        public void bindToRegistry(Registry var1) throws Exception;
    }

    @FunctionalInterface
    public static interface RoutesSupplier {
        public RoutesBuilder[] createRouteBuilders() throws Exception;
    }

    @FunctionalInterface
    public static interface PostProcessor {
        public void postSetup() throws Exception;
    }
}

