/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.camel.test.cdi.CamelCdiContext;
import org.apache.camel.test.cdi.FrameworkMethodInjectionPoint;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

final class FrameworkMethodCdiInjection
extends Statement {
    private final FrameworkMethod method;
    private final Object test;
    private final CamelCdiContext context;

    FrameworkMethodCdiInjection(FrameworkMethod method, Object test, CamelCdiContext context) {
        this.method = method;
        this.test = test;
        this.context = context;
    }

    public void evaluate() throws Throwable {
        BeanManager manager = this.context.getBeanManager();
        Type[] types = this.method.getMethod().getGenericParameterTypes();
        Object[] parameters = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            parameters[i] = manager.getInjectableReference((InjectionPoint)new FrameworkMethodInjectionPoint(this.method.getMethod(), i, manager), manager.createCreationalContext(null));
        }
        this.method.invokeExplosively(this.test, parameters);
    }
}

