/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractMessagingSpanDecorator;

public class AzureServiceBusSpanDecorator
extends AbstractMessagingSpanDecorator {
    static final String SERVICEBUS_CONTENT_TYPE = "contentType";
    static final String SERVICEBUS_CORRELATION_ID = "correlationId";
    static final String SERVICEBUS_DELIVERY_COUNT = "deliveryCount";
    static final String SERVICEBUS_ENQUEUED_SEQUENCE_NUMBER = "enqueuedSequenceNumber";
    static final String SERVICEBUS_ENQUEUED_TIME = "enqueuedTime";
    static final String SERVICEBUS_EXPIRES_AT = "expiresAt";
    static final String SERVICEBUS_PARTITION_KEY = "partitionKey";
    static final String SERVICEBUS_REPLY_TO_SESSION_ID = "replyToSessionId";
    static final String SERVICEBUS_SESSION_ID = "sessionId";
    static final String SERVICEBUS_TIME_TO_LIVE = "ttl";
    static final String CONTENT_TYPE = "CamelAzureServiceBusContentType";
    static final String CORRELATION_ID = "CamelAzureServiceBusCorrelationId";
    static final String DELIVERY_COUNT = "CamelAzureServiceBusDeliveryCount";
    static final String ENQUEUED_SEQUENCE_NUMBER = "CamelAzureServiceBusEnqueuedSequenceNumber";
    static final String ENQUEUED_TIME = "CamelAzureServiceBusEnqueuedTime";
    static final String EXPIRES_AT = "CamelAzureServiceBusExpiresAt";
    static final String MESSAGE_ID = "CamelAzureServiceBusMessageId";
    static final String SESSION_ID = "CamelAzureServiceBusSessionId";
    static final String REPLY_TO_SESSION_ID = "CamelAzureServiceBusReplyToSessionId";
    static final String PARTITION_KEY = "CamelAzureServiceBusPartitionKey";
    static final String TIME_TO_LIVE = "CamelAzureServiceBusTimeToLive";

    @Override
    public String getComponent() {
        return "azure-servicebus";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.azure.servicebus.ServiceBusComponent";
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        Duration timeToLive;
        String sessionId;
        String replyToSessionId;
        String partitionKey;
        OffsetDateTime expiresAt;
        OffsetDateTime enqueuedTime;
        Long enqueuedSequenceNumber;
        Long deliveryCount;
        String correlationId;
        super.beforeTracingEvent(span, exchange, endpoint);
        String contentType = (String)exchange.getIn().getHeader(CONTENT_TYPE, String.class);
        if (contentType != null) {
            span.setTag(SERVICEBUS_CONTENT_TYPE, contentType);
        }
        if ((correlationId = (String)exchange.getIn().getHeader(CORRELATION_ID, String.class)) != null) {
            span.setTag(SERVICEBUS_CORRELATION_ID, correlationId);
        }
        if ((deliveryCount = (Long)exchange.getIn().getHeader(DELIVERY_COUNT, Long.class)) != null) {
            span.setTag(SERVICEBUS_DELIVERY_COUNT, deliveryCount.toString());
        }
        if ((enqueuedSequenceNumber = (Long)exchange.getIn().getHeader(ENQUEUED_SEQUENCE_NUMBER, Long.class)) != null) {
            span.setTag(SERVICEBUS_ENQUEUED_SEQUENCE_NUMBER, enqueuedSequenceNumber.toString());
        }
        if ((enqueuedTime = (OffsetDateTime)exchange.getIn().getHeader(ENQUEUED_TIME, OffsetDateTime.class)) != null) {
            span.setTag(SERVICEBUS_ENQUEUED_TIME, enqueuedTime.toString());
        }
        if ((expiresAt = (OffsetDateTime)exchange.getIn().getHeader(EXPIRES_AT, OffsetDateTime.class)) != null) {
            span.setTag(SERVICEBUS_EXPIRES_AT, expiresAt.toString());
        }
        if ((partitionKey = (String)exchange.getIn().getHeader(PARTITION_KEY, String.class)) != null) {
            span.setTag(SERVICEBUS_PARTITION_KEY, partitionKey);
        }
        if ((replyToSessionId = (String)exchange.getIn().getHeader(REPLY_TO_SESSION_ID, String.class)) != null) {
            span.setTag(SERVICEBUS_REPLY_TO_SESSION_ID, replyToSessionId);
        }
        if ((sessionId = (String)exchange.getIn().getHeader(SESSION_ID, String.class)) != null) {
            span.setTag(SERVICEBUS_SESSION_ID, sessionId);
        }
        if ((timeToLive = (Duration)exchange.getIn().getHeader(TIME_TO_LIVE, Duration.class)) != null) {
            span.setTag(SERVICEBUS_TIME_TO_LIVE, timeToLive.toString());
        }
    }

    @Override
    protected String getMessageId(Exchange exchange) {
        return (String)exchange.getIn().getHeader(MESSAGE_ID, String.class);
    }
}

