/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry;

import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.SpanStorageManager;

public class SpanStorageManagerExchange
implements SpanStorageManager {
    protected static String ACTIVE_SPAN = "tracing.activeSpan";

    @Override
    public Span peek(Exchange exchange) {
        SpanWrapper wrap = (SpanWrapper)exchange.getProperty(ACTIVE_SPAN, SpanWrapper.class);
        if (wrap == null) {
            return null;
        }
        return wrap.current;
    }

    @Override
    public Span pull(Exchange exchange) {
        SpanWrapper wrap = (SpanWrapper)exchange.getProperty(ACTIVE_SPAN, SpanWrapper.class);
        if (wrap == null) {
            return null;
        }
        exchange.removeProperty(ACTIVE_SPAN);
        if (wrap.parent != null) {
            exchange.setProperty(ACTIVE_SPAN, (Object)wrap.parent);
        }
        return wrap.current;
    }

    @Override
    public void push(Exchange exchange, Span span) {
        SpanWrapper parentWrap = (SpanWrapper)exchange.getProperty(ACTIVE_SPAN, SpanWrapper.class);
        SpanWrapper currentWrap = new SpanWrapper(span, parentWrap);
        exchange.setProperty(ACTIVE_SPAN, (Object)currentWrap);
    }

    class SpanWrapper {
        private Span current;
        private SpanWrapper parent;

        public SpanWrapper(Span current, SpanWrapper parent) {
            this.current = current;
            this.parent = parent;
        }
    }
}

