/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class RestSwaggerCorsFilter
implements Filter {
    private final Map<String, String> corsHeaders = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String s = filterConfig.getInitParameter("Access-Control-Allow-Origin");
        if (s != null) {
            this.corsHeaders.put("Access-Control-Allow-Origin", s);
        }
        if ((s = filterConfig.getInitParameter("Access-Control-Allow-Methods")) != null) {
            this.corsHeaders.put("Access-Control-Allow-Methods", s);
        }
        if ((s = filterConfig.getInitParameter("Access-Control-Allow-Headers")) != null) {
            this.corsHeaders.put("Access-Control-Allow-Headers", s);
        }
        if ((s = filterConfig.getInitParameter("Access-Control-Max-Age")) != null) {
            this.corsHeaders.put("Access-Control-Max-Age", s);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        RestSwaggerCorsFilter.setupCorsHeaders(res, this.corsHeaders);
        chain.doFilter(request, response);
    }

    private static void setupCorsHeaders(HttpServletResponse response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }
}

