/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cluster;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReferenceCount;
import org.apache.camel.util.concurrent.LockHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelClusterService<T extends CamelClusterView>
extends ServiceSupport
implements CamelClusterService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelClusterService.class);
    private final Map<String, ViewHolder<T>> views;
    private final Map<String, Object> attributes;
    private final StampedLock lock;
    private int order = 2147482647;
    private String id;
    private CamelContext camelContext;

    protected AbstractCamelClusterService() {
        this(null, null);
    }

    protected AbstractCamelClusterService(String id) {
        this(id, null);
    }

    protected AbstractCamelClusterService(String id, CamelContext camelContext) {
        this.id = id;
        this.camelContext = camelContext;
        this.views = new HashMap<String, ViewHolder<T>>();
        this.lock = new StampedLock();
        this.attributes = new HashMap<String, Object>();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        LockHelper.doWithWriteLock((StampedLock)this.lock, () -> {
            for (ViewHolder<T> holder : this.views.values()) {
                holder.get().setCamelContext(camelContext);
            }
        });
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    protected void doStart() throws Exception {
        LockHelper.doWithReadLockT((StampedLock)this.lock, () -> {
            for (ViewHolder<T> holder : this.views.values()) {
                holder.get().start();
            }
        });
    }

    protected void doStop() throws Exception {
        LockHelper.doWithReadLockT((StampedLock)this.lock, () -> {
            for (ViewHolder<T> holder : this.views.values()) {
                holder.get().stop();
            }
        });
    }

    public CamelClusterView getView(String namespace) throws Exception {
        return (CamelClusterView)LockHelper.callWithWriteLock((StampedLock)this.lock, () -> {
            ViewHolder holder = this.views.get(namespace);
            if (holder == null) {
                T view = this.createView(namespace);
                view.setCamelContext(this.camelContext);
                holder = new ViewHolder(this, view);
                this.views.put(namespace, holder);
            }
            return holder.retain();
        });
    }

    public void releaseView(CamelClusterView view) throws Exception {
        LockHelper.doWithWriteLock((StampedLock)this.lock, () -> {
            ViewHolder<T> holder = this.views.get(view.getNamespace());
            if (holder != null) {
                holder.release();
            }
        });
    }

    public Collection<String> getNamespaces() {
        return (Collection)LockHelper.supplyWithReadLock((StampedLock)this.lock, () -> new HashSet<String>(this.views.keySet()));
    }

    public void startView(String namespace) throws Exception {
        LockHelper.doWithWriteLockT((StampedLock)this.lock, () -> {
            ViewHolder<T> holder = this.views.get(namespace);
            if (holder != null) {
                LOG.info("Force start of view {}", (Object)namespace);
                holder.startView();
            } else {
                LOG.warn("Error forcing start of view {}: it does not exist", (Object)namespace);
            }
        });
    }

    public void stopView(String namespace) throws Exception {
        LockHelper.doWithWriteLockT((StampedLock)this.lock, () -> {
            ViewHolder<T> holder = this.views.get(namespace);
            if (holder != null) {
                LOG.info("Force stop of view {}", (Object)namespace);
                holder.stopView();
            } else {
                LOG.warn("Error forcing stop of view {}: it does not exist", (Object)namespace);
            }
        });
    }

    public boolean isLeader(String namespace) {
        return (Boolean)LockHelper.supplyWithReadLock((StampedLock)this.lock, () -> {
            CamelClusterMember member;
            ViewHolder<T> holder = this.views.get(namespace);
            if (holder != null && (member = holder.get().getLocalMember()) != null) {
                return member.isLeader();
            }
            return false;
        });
    }

    protected abstract T createView(String var1) throws Exception;

    private static final class ViewHolder<V extends CamelClusterView> {
        private final V view;
        private final ReferenceCount count;
        final /* synthetic */ AbstractCamelClusterService this$0;

        ViewHolder(V view) {
            this.this$0 = var1_1;
            this.view = view;
            this.count = ReferenceCount.on(() -> {
                try {
                    this.startView();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, () -> {
                try {
                    this.stopView();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        V get() {
            return this.view;
        }

        V retain() {
            LOG.debug("Retain view {}, old-refs={}", (Object)this.view.getNamespace(), (Object)this.count.get());
            this.count.retain();
            return this.get();
        }

        void release() {
            LOG.debug("Release view {}, old-refs={}", (Object)this.view.getNamespace(), (Object)this.count.get());
            this.count.release();
        }

        void startView() throws Exception {
            if (this.this$0.isRunAllowed()) {
                LOG.debug("Start view {}", (Object)this.view.getNamespace());
                this.view.start();
            } else {
                LOG.debug("Can't start view {} as cluster service is not running, view will be started on service start-up", (Object)this.view.getNamespace());
            }
        }

        void stopView() throws Exception {
            LOG.debug("Stop view {}", (Object)this.view.getNamespace());
            this.view.stop();
        }
    }
}

