/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed RouteOnDemandReloadStrategy")
public class RouteOnDemandReloadStrategy
extends RouteWatcherReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RouteOnDemandReloadStrategy.class);

    public RouteOnDemandReloadStrategy() {
        this.setScheduler(false);
    }

    public RouteOnDemandReloadStrategy(String directory) {
        super(directory);
        this.setScheduler(false);
    }

    public RouteOnDemandReloadStrategy(String directory, boolean recursive) {
        super(directory, recursive);
        this.setScheduler(false);
    }

    @ManagedOperation(description="Trigger on-demand reloading")
    public void onReload() {
        this.onReload("JMX Management");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(Object source) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.setLastError(null);
            ClassLoader acl = this.getCamelContext().getApplicationContextClassLoader();
            if (acl != null) {
                Thread.currentThread().setContextClassLoader(acl);
            }
            this.doOnReload(source);
            this.incSucceededCounter();
        }
        catch (Exception e) {
            this.setLastError(e);
            this.incFailedCounter();
            LOG.warn("Error reloading routes due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void doOnReload(Object source) throws Exception {
        ArrayList<Resource> properties = new ArrayList<Resource>();
        ArrayList<Resource> groovy = new ArrayList<Resource>();
        ArrayList<Resource> routes = new ArrayList<Resource>();
        File dir = new File(this.getFolder());
        for (Path path : ResourceHelper.findInFileSystem(dir.toPath(), this.getPattern())) {
            Resource res = ResourceHelper.resolveResource(this.getCamelContext(), "file:" + path.toString());
            String ext = FileUtil.onlyExt((String)path.getFileName().toString());
            if ("properties".equals(ext)) {
                properties.add(res);
                continue;
            }
            if ("groovy".equals(ext)) {
                groovy.add(res);
                continue;
            }
            routes.add(res);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("On-demand reload scanned {} files (properties: {}, routes: {}, groovy: {})", new Object[]{properties.size() + routes.size(), properties.size(), routes.size(), groovy.size()});
        }
        boolean reloaded = false;
        for (Resource res : properties) {
            reloaded |= this.onPropertiesReload(res, false);
        }
        for (Resource res : groovy) {
            reloaded |= this.onGroovyReload(res, false);
        }
        boolean bl = routes.isEmpty();
        if (reloaded || !routes.isEmpty()) {
            this.onRouteReload(routes, bl);
        } else {
            this.onRouteReload(null, bl);
        }
    }
}

