/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertBodyProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Class<?> type;
    private final String charset;
    private final boolean mandatory;

    public ConvertBodyProcessor(Class<?> type) {
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.type = type;
        this.charset = null;
        this.mandatory = true;
    }

    public ConvertBodyProcessor(Class<?> type, String charset) {
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.type = type;
        this.charset = IOHelper.normalizeCharset((String)charset);
        this.mandatory = true;
    }

    public ConvertBodyProcessor(Class<?> type, String charset, boolean mandatory) {
        ObjectHelper.notNull(type, (String)"type", (Object)((Object)this));
        this.type = type;
        this.charset = IOHelper.normalizeCharset((String)charset);
        this.mandatory = mandatory;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public void process(Exchange exchange) throws Exception {
        boolean copyNeeded;
        Message old = exchange.getMessage();
        if (old.getBody() == null) {
            return;
        }
        if (exchange.getException() != null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.charset);
        }
        Object value = this.mandatory ? old.getMandatoryBody(this.type) : old.getBody(this.type);
        boolean bl = copyNeeded = !old.getClass().equals(DefaultMessage.class);
        if (copyNeeded) {
            DefaultMessage msg = new DefaultMessage(exchange.getContext());
            msg.copyFromWithNewBody(old, value);
            ExchangeHelper.replaceMessage(exchange, msg, false);
        } else {
            old.setBody(value);
        }
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)originalCharsetName);
            } else {
                exchange.removeProperty(ExchangePropertyKey.CHARSET_NAME);
            }
        }
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }
}

