/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextReloadStrategy
extends ServiceSupport
implements ContextReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextReloadStrategy.class);
    private CamelContext camelContext;
    private int succeeded;
    private int failed;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedOperation(description="Trigger on-demand reloading")
    public void onReload() {
        this.onReload("JMX Management");
    }

    public void onReload(Object source) {
        LOG.info("Reloading CamelContext ({}) triggered by: {}", (Object)this.camelContext.getName(), source);
        try {
            EventHelper.notifyContextReloading(this.getCamelContext(), source);
            this.reloadProperties(source);
            this.reloadRoutes(source);
            this.incSucceededCounter();
            EventHelper.notifyContextReloaded(this.getCamelContext(), source);
        }
        catch (Exception e) {
            this.incFailedCounter();
            LOG.warn("Error reloading CamelContext (" + this.camelContext.getName() + ") due to: " + e.getMessage(), (Throwable)e);
            EventHelper.notifyContextReloadFailure(this.getCamelContext(), source, e);
        }
    }

    protected void reloadRoutes(Object source) throws Exception {
        this.getCamelContext().getRouteController().reloadAllRoutes();
    }

    protected void reloadProperties(Object source) throws Exception {
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        for (PropertiesSource ps : pc.getPropertiesSources()) {
            ServiceHelper.stopAndShutdownService((Object)ps);
            ServiceHelper.startService((Object)ps);
        }
    }

    @ManagedAttribute(description="Number of reloads succeeded")
    public int getReloadCounter() {
        return this.succeeded;
    }

    @ManagedAttribute(description="Number of reloads failed")
    public int getFailedCounter() {
        return this.failed;
    }

    public void setSucceeded(int succeeded) {
        this.succeeded = succeeded;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    @ManagedOperation(description="Reset counters")
    public void resetCounters() {
        this.succeeded = 0;
        this.failed = 0;
    }

    protected void incSucceededCounter() {
        ++this.succeeded;
    }

    protected void incFailedCounter() {
        ++this.failed;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

