/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.stored.template.ast.InOutParameter;
import org.apache.camel.component.sql.stored.template.ast.InParameter;
import org.apache.camel.component.sql.stored.template.ast.OutParameter;
import org.apache.camel.component.sql.stored.template.ast.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlInOutParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.StoredProcedure;

public class TemplateStoredProcedure
extends StoredProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateStoredProcedure.class);
    private final Template template;
    private List<InParameter> inParameterList = new ArrayList<InParameter>();
    private List<InOutParameter> inOutParameterList = new ArrayList<InOutParameter>();

    public TemplateStoredProcedure(JdbcTemplate jdbcTemplate, Template template, boolean function) {
        this.template = template;
        this.setFunction(function);
        this.setDataSource(jdbcTemplate.getDataSource());
        this.setSql(template.getProcedureName());
        for (Object parameter : template.getParameterList()) {
            if (parameter instanceof InParameter) {
                InParameter inputParameter = (InParameter)parameter;
                SqlParameter sqlParameter = inputParameter.getScale() != null ? new SqlParameter(inputParameter.getName(), inputParameter.getSqlType(), inputParameter.getScale().intValue()) : (inputParameter.getTypeName() != null ? new SqlParameter(inputParameter.getName(), inputParameter.getSqlType(), inputParameter.getTypeName()) : new SqlParameter(inputParameter.getName(), inputParameter.getSqlType()));
                this.declareParameter(sqlParameter);
                this.inParameterList.add(inputParameter);
                continue;
            }
            if (parameter instanceof InOutParameter) {
                InOutParameter inOutParameter = (InOutParameter)parameter;
                SqlInOutParameter sqlInOutParameter = inOutParameter.getScale() != null ? new SqlInOutParameter(inOutParameter.getOutValueMapKey(), inOutParameter.getSqlType(), inOutParameter.getScale().intValue()) : (inOutParameter.getTypeName() != null ? new SqlInOutParameter(inOutParameter.getOutValueMapKey(), inOutParameter.getSqlType(), inOutParameter.getTypeName()) : new SqlInOutParameter(inOutParameter.getOutValueMapKey(), inOutParameter.getSqlType()));
                this.declareParameter((SqlParameter)sqlInOutParameter);
                this.inOutParameterList.add(inOutParameter);
                continue;
            }
            if (!(parameter instanceof OutParameter)) continue;
            OutParameter outParameter = (OutParameter)parameter;
            SqlOutParameter sqlOutParameter = outParameter.getScale() != null ? new SqlOutParameter(outParameter.getOutValueMapKey(), outParameter.getSqlType(), outParameter.getScale().intValue()) : (outParameter.getTypeName() != null ? new SqlOutParameter(outParameter.getOutValueMapKey(), outParameter.getSqlType(), outParameter.getTypeName()) : new SqlOutParameter(outParameter.getOutValueMapKey(), outParameter.getSqlType()));
            this.declareParameter((SqlParameter)sqlOutParameter);
        }
        LOG.debug("Compiling stored procedure: {}", (Object)template.getProcedureName());
        this.compile();
    }

    public Map execute(Exchange exchange, Object rowData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (InParameter inParameter : this.inParameterList) {
            params.put(inParameter.getName(), inParameter.getValueExtractor().eval(exchange, rowData));
        }
        for (InOutParameter inOutParameter : this.inOutParameterList) {
            params.put(inOutParameter.getOutValueMapKey(), inOutParameter.getValueExtractor().eval(exchange, rowData));
        }
        LOG.debug("Invoking stored procedure: {}", (Object)this.template.getProcedureName());
        return super.execute(params);
    }

    public Template getTemplate() {
        return this.template;
    }
}

