/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@SendDynamic(value="spring-rabbitmq")
public class SpringRabbitMQSendDynamicAware
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private String scheme;

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, null, null);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String originalRoutingKey;
        String routingKey;
        String originalExchangeName;
        String answer = null;
        String exchangeName = this.parseExchangeName(entry.getUri());
        if (exchangeName != null && !exchangeName.equals(originalExchangeName = this.parseExchangeName(entry.getOriginalUri()))) {
            answer = entry.getUri();
            answer = StringHelper.replaceFirst((String)answer, (String)exchangeName, (String)originalExchangeName);
        }
        if ((routingKey = this.parseRoutingKey(entry.getUri())) != null && !routingKey.equals(originalRoutingKey = this.parseRoutingKey(entry.getOriginalUri()))) {
            if (answer == null) {
                answer = entry.getUri();
            }
            answer = StringHelper.replaceFirst((String)answer, (String)("routingKey=" + routingKey), (String)("routingKey=" + originalRoutingKey));
        }
        return answer;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String s = (String)exchange.getMessage().getHeader("CamelSpringRabbitmqExchangeOverrideName", String.class);
        final String destinationName = s != null ? s : this.parseExchangeName(entry.getUri());
        s = (String)exchange.getMessage().getHeader("CamelSpringRabbitmqRoutingOverrideKey", String.class);
        final String routingKey = s != null ? s : this.parseRoutingKey(entry.getUri());
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                if (destinationName != null) {
                    exchange.getMessage().setHeader("CamelSpringRabbitmqExchangeOverrideName", (Object)destinationName);
                }
                if (routingKey != null) {
                    exchange.getMessage().setHeader("CamelSpringRabbitmqRoutingOverrideKey", (Object)routingKey);
                }
            }
        };
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    private String parseExchangeName(String uri) {
        int pos = uri.indexOf(63);
        if (pos != -1) {
            uri = uri.substring(0, pos);
        }
        if ((pos = uri.indexOf(58)) != -1) {
            return uri.substring(pos + 1);
        }
        return null;
    }

    private String parseRoutingKey(String uri) throws URISyntaxException {
        String query = URISupport.extractQuery((String)uri);
        if (query != null) {
            Object key = URISupport.parseQuery((String)query).get("routingKey");
            return key != null ? key.toString() : null;
        }
        return null;
    }
}

