/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.component.springrabbit.SpringRabbitMQEndpoint;
import org.apache.camel.component.springrabbit.SpringRabbitMQHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class SpringRabbitMQProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringRabbitMQProducer.class);
    private RabbitTemplate inOnlyTemplate;
    private AsyncRabbitTemplate inOutTemplate;

    public SpringRabbitMQProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public SpringRabbitMQEndpoint getEndpoint() {
        return (SpringRabbitMQEndpoint)super.getEndpoint();
    }

    public RabbitTemplate getInOnlyTemplate() {
        if (this.inOutTemplate == null) {
            this.inOnlyTemplate = this.getEndpoint().createInOnlyTemplate();
        }
        return this.inOnlyTemplate;
    }

    public void setInOnlyTemplate(RabbitTemplate inOnlyTemplate) {
        this.inOnlyTemplate = inOnlyTemplate;
    }

    public AsyncRabbitTemplate getInOutTemplate() {
        if (this.inOutTemplate == null) {
            this.inOutTemplate = this.getEndpoint().createInOutTemplate();
        }
        this.inOutTemplate.start();
        return this.inOutTemplate;
    }

    public void setInOutTemplate(AsyncRabbitTemplate inOutTemplate) {
        this.inOutTemplate = inOutTemplate;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().isTestConnectionOnStartup()) {
            this.testConnectionOnStartup();
        }
    }

    protected void doStop() throws Exception {
        if (this.inOnlyTemplate != null) {
            this.inOnlyTemplate.stop();
            this.inOnlyTemplate = null;
        }
        if (this.inOutTemplate != null) {
            this.inOutTemplate.stop();
            this.inOutTemplate = null;
        }
        super.doStop();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
        try {
            if (!this.getEndpoint().isDisableReplyTo() && exchange.getPattern().isOutCapable()) {
                return this.processInOut(exchange, callback);
            }
            return this.processInOnly(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOut(final Exchange exchange, final AsyncCallback callback) {
        Message msg;
        Object body;
        String exchangeName = (String)exchange.getMessage().removeHeader("CamelSpringRabbitmqExchangeOverrideName");
        if (exchangeName == null) {
            exchangeName = this.getEndpoint().getExchangeName();
        }
        exchangeName = SpringRabbitMQHelper.isDefaultExchange(exchangeName) ? "" : exchangeName;
        String routingKey = (String)exchange.getMessage().removeHeader("CamelSpringRabbitmqRoutingOverrideKey");
        if (routingKey == null) {
            routingKey = this.getEndpoint().getRoutingKey();
        }
        if ((body = exchange.getMessage().getBody()) instanceof Message) {
            msg = (Message)body;
        } else {
            MessageProperties mp = this.getEndpoint().getMessagePropertiesConverter().toMessageProperties(exchange);
            msg = this.getEndpoint().getMessageConverter().toMessage(body, mp);
        }
        try {
            AsyncRabbitTemplate.RabbitMessageFuture future = this.getInOutTemplate().sendAndReceive(exchangeName, routingKey, msg);
            future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<Message>(){

                public void onFailure(Throwable throwable) {
                    exchange.setException(throwable);
                    callback.done(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Message message) {
                    try {
                        Object body = SpringRabbitMQProducer.this.getEndpoint().getMessageConverter().fromMessage(message);
                        exchange.getMessage().setBody(body);
                        Map<String, Object> headers = SpringRabbitMQProducer.this.getEndpoint().getMessagePropertiesConverter().fromMessageProperties(message.getMessageProperties(), exchange);
                        if (!headers.isEmpty()) {
                            exchange.getMessage().getHeaders().putAll(headers);
                        }
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                    }
                    finally {
                        callback.done(false);
                    }
                }
            });
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected boolean processInOnly(Exchange exchange, AsyncCallback callback) {
        Message msg;
        Object body;
        String exchangeName = (String)exchange.getMessage().removeHeader("CamelSpringRabbitmqExchangeOverrideName");
        if (exchangeName == null) {
            exchangeName = this.getEndpoint().getExchangeName();
        }
        exchangeName = SpringRabbitMQHelper.isDefaultExchange(exchangeName) ? "" : exchangeName;
        String routingKey = (String)exchange.getMessage().removeHeader("CamelSpringRabbitmqRoutingOverrideKey");
        if (routingKey == null) {
            routingKey = this.getEndpoint().getRoutingKey();
        }
        if ((body = exchange.getMessage().getBody()) instanceof Message) {
            msg = (Message)body;
        } else {
            MessageProperties mp = this.getEndpoint().getMessagePropertiesConverter().toMessageProperties(exchange);
            msg = this.getEndpoint().getMessageConverter().toMessage(body, mp);
        }
        try {
            this.getInOnlyTemplate().send(exchangeName, routingKey, msg);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected void testConnectionOnStartup() throws FailedToCreateProducerException {
        Connection conn = null;
        try {
            RabbitTemplate template = this.getInOnlyTemplate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Testing RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
            }
            conn = template.getConnectionFactory().createConnection();
            LOG.debug("Successfully tested RabbitMQ Connection on startup for: {}", (Object)this.getEndpoint().getConnectionFactory().getHost());
        }
        catch (Exception e) {
            try {
                throw new FailedToCreateProducerException((Endpoint)this.getEndpoint(), (Throwable)e);
            }
            catch (Throwable throwable) {
                RabbitUtils.closeConnection(conn);
                throw throwable;
            }
        }
        RabbitUtils.closeConnection((Connection)conn);
    }
}

