/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springrabbit;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SpringRabbitMQEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":exchangeName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "spring-rabbitmq".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "exchangeName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(35);
        props.add("asyncConsumer");
        props.add("prefetchCount");
        props.add("synchronous");
        props.add("maximumRetryAttempts");
        props.add("messageConverter");
        props.add("exchangeType");
        props.add("rejectAndDontRequeue");
        props.add("autoStartup");
        props.add("noLocal");
        props.add("retryDelay");
        props.add("bridgeErrorHandler");
        props.add("deadLetterRoutingKey");
        props.add("messagePropertiesConverter");
        props.add("exclusive");
        props.add("retry");
        props.add("disableReplyTo");
        props.add("maxConcurrentConsumers");
        props.add("deadLetterExchange");
        props.add("exchangePattern");
        props.add("deadLetterExchangeType");
        props.add("concurrentConsumers");
        props.add("messageListenerContainerType");
        props.add("args");
        props.add("lazyStartProducer");
        props.add("deadLetterQueue");
        props.add("connectionFactory");
        props.add("testConnectionOnStartup");
        props.add("acknowledgeMode");
        props.add("queues");
        props.add("exchangeName");
        props.add("replyTimeout");
        props.add("usePublisherConnection");
        props.add("exceptionHandler");
        props.add("routingKey");
        props.add("autoDeclare");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

