/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
public abstract class CamelConfiguration
implements BeanFactoryAware,
ApplicationContextAware {
    private BeanFactory beanFactory;
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private ApplicationContext applicationContext;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.autowireCapableBeanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setApplicationContext(ApplicationContext ac) {
        this.applicationContext = ac;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object getBean(String beanName) {
        return this.beanFactory.getBean(beanName);
    }

    public <T> T getBean(Class<T> type) {
        return (T)this.beanFactory.getBean(type);
    }

    public <T> T getBean(String beanName, Class<T> type) {
        return (T)this.beanFactory.getBean(beanName, type);
    }

    protected <T> T getConfigured(T object) {
        if (this.autowireCapableBeanFactory == null) {
            throw new UnsupportedOperationException("Cannot configure object - not running in an AutowireCapableBeanFactory");
        }
        Object configuredObject = this.autowireCapableBeanFactory.initializeBean(object, null);
        if (this.applicationContext != null) {
            if (configuredObject instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)configuredObject).setResourceLoader((ResourceLoader)this.applicationContext);
            }
            if (configuredObject instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)configuredObject).setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
            }
            if (configuredObject instanceof MessageSourceAware) {
                ((MessageSourceAware)configuredObject).setMessageSource((MessageSource)this.applicationContext);
            }
            if (configuredObject instanceof ApplicationContextAware) {
                ((ApplicationContextAware)configuredObject).setApplicationContext(this.applicationContext);
            }
        }
        return (T)configuredObject;
    }

    @Bean
    public CamelBeanPostProcessor camelBeanPostProcessor() throws Exception {
        CamelBeanPostProcessor answer = new CamelBeanPostProcessor();
        answer.setApplicationContext(this.getApplicationContext());
        return answer;
    }

    @Bean
    public CamelContext camelContext() throws Exception {
        CamelContext camelContext = this.createCamelContext();
        this.setupCamelContext(camelContext);
        List<RouteBuilder> routes = this.routes();
        for (RoutesBuilder routesBuilder : routes) {
            camelContext.addRoutes(routesBuilder);
        }
        return camelContext;
    }

    protected void setupCamelContext(CamelContext camelContext) throws Exception {
    }

    protected CamelContext createCamelContext() throws Exception {
        return new SpringCamelContext(this.getApplicationContext());
    }

    public List<RouteBuilder> routes() {
        if (this.applicationContext != null) {
            Map routeBuildersMap = this.applicationContext.getBeansOfType(RouteBuilder.class);
            ArrayList<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>(routeBuildersMap.size());
            for (RouteBuilder routeBuilder : routeBuildersMap.values()) {
                routeBuilders.add(routeBuilder);
            }
            return routeBuilders;
        }
        return Collections.emptyList();
    }
}

