/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;

@JsonPropertyOrder(value={"id", "description", "uptime", "uptimeMillis"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RouteInfo {
    private final String id;
    private final String description;
    private final String uptime;
    private final long uptimeMillis;
    private final String status;

    public RouteInfo(Route route) {
        this.id = route.getId();
        this.description = route.getDescription();
        this.uptime = route.getUptime();
        this.uptimeMillis = route.getUptimeMillis();
        this.status = route instanceof StatefulService ? ((StatefulService)route).getStatus().name() : null;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUptime() {
        return this.uptime;
    }

    public long getUptimeMillis() {
        return this.uptimeMillis;
    }

    public String getStatus() {
        return this.status;
    }
}

