/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;

public class FatJarPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private static final String SPRINGBOOT_CLASSIC_LIB_ROOT = "lib/";
    private static final String SPRINGBOOT_BOOT_INF_LIB_ROOT = "BOOT-INF/lib/";
    private static final String SPRINGBOOT_BOOT_INF_CLASSES_ROOT = "BOOT-INF/classes/";

    protected List<String> doLoadJarClassEntries(InputStream stream, String urlPath) {
        return this.doLoadJarClassEntries(stream, urlPath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doLoadJarClassEntries(InputStream stream, String urlPath, boolean inspectNestedJars, boolean closeStream) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (!entry.isDirectory() && name.endsWith(".class")) {
                    entries.add(this.cleanupSpringbootClassName(name));
                    continue;
                }
                if (!inspectNestedJars || entry.isDirectory() || !this.isSpringbootNestedJar(name)) continue;
                String nestedUrl = urlPath + "!/" + name;
                this.log.trace("Inspecting nested jar: {}", (Object)nestedUrl);
                List<String> nestedEntries = this.doLoadJarClassEntries(jarStream, nestedUrl, false, false);
                entries.addAll(nestedEntries);
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot search jar file '" + urlPath + " due to an IOException: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            if (closeStream) {
                IOHelper.close((Closeable)jarStream, (String)urlPath, (Logger)this.log);
            }
        }
        return entries;
    }

    private boolean isSpringbootNestedJar(String name) {
        return name.endsWith(".jar") && (name.startsWith(SPRINGBOOT_CLASSIC_LIB_ROOT) || name.startsWith(SPRINGBOOT_BOOT_INF_LIB_ROOT));
    }

    private String cleanupSpringbootClassName(String name) {
        if (name.startsWith(SPRINGBOOT_BOOT_INF_CLASSES_ROOT)) {
            name = name.substring(SPRINGBOOT_BOOT_INF_CLASSES_ROOT.length());
        }
        return name;
    }
}

