/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry2;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Map;

public class OpenTelemetrySpanAdapter
implements org.apache.camel.telemetry.Span {
    private static final String DEFAULT_EVENT_NAME = "log";
    private final Span otelSpan;
    private final Baggage baggage;
    private Scope scope;

    protected OpenTelemetrySpanAdapter(Span otelSpan, Baggage baggage) {
        this.otelSpan = otelSpan;
        this.baggage = baggage;
    }

    protected Span getSpan() {
        return this.otelSpan;
    }

    protected void makeCurrent() {
        this.scope = this.otelSpan.makeCurrent();
    }

    protected void end() {
        this.otelSpan.end();
    }

    protected void close() {
        if (this.scope != null) {
            this.scope.close();
        }
    }

    protected Baggage getBaggage() {
        return this.baggage;
    }

    public void log(Map<String, String> fields) {
        this.otelSpan.addEvent(this.getEventNameFromFields(fields), this.convertToAttributes(fields));
    }

    public void setTag(String key, String value) {
        this.otelSpan.setAttribute(key, value);
    }

    public void setComponent(String component) {
        this.setTag("component", component);
    }

    public void setError(boolean isError) {
        this.setTag("error", "" + isError);
    }

    private String getEventNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("event");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    private Attributes convertToAttributes(Map<String, ?> fields) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                attributesBuilder.put(key, ((Number)value).longValue());
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                attributesBuilder.put(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                attributesBuilder.put(key, ((Boolean)value).booleanValue());
                continue;
            }
            attributesBuilder.put(key, value.toString());
        }
        return attributesBuilder.build();
    }

    public String toString() {
        return "OpenTelemetrySpanAdapter [span=" + String.valueOf(this.otelSpan) + ", baggage=" + String.valueOf(this.baggage) + "]";
    }
}

