/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.observation.MicrometerObservationSpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCorrelationContextProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(GetCorrelationContextProcessor.class);
    private final String headerName;
    private final String keyName;
    private String id;
    private String routeId;

    public GetCorrelationContextProcessor(String keyName, String headerName) {
        this.keyName = (String)ObjectHelper.notNull((Object)keyName, (String)"keyName");
        this.headerName = (String)ObjectHelper.notNull((Object)headerName, (String)"headerName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            MicrometerObservationSpanAdapter camelSpan = (MicrometerObservationSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            if (camelSpan != null) {
                String item = camelSpan.getContextPropagationItem(this.keyName);
                exchange.getMessage().setHeader(this.headerName, (Object)item);
            } else {
                LOG.warn("Micrometer Observation: Cannot find managed span for exchange: {}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String getTraceLabel() {
        return "getCorrelationContext[" + this.keyName + ", " + this.headerName + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public String toString() {
        return this.id;
    }
}

