/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.mdc;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.mdc.MDCProcessorsInterceptStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.CamelMDCService;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@JdkService(value="mdc-service")
public class MDCService
extends ServiceSupport
implements CamelMDCService {
    static String MDC_BREADCRUMB_ID = "camel.breadcrumbId";
    static String MDC_EXCHANGE_ID = "camel.exchangeId";
    static String MDC_MESSAGE_ID = "camel.messageId";
    static String MDC_CORRELATION_ID = "camel.correlationId";
    static String MDC_ROUTE_ID = "camel.routeId";
    static String MDC_CAMEL_THREAD_ID = "camel.threadId";
    static String MDC_CAMEL_CONTEXT_ID = "camel.contextId";
    private static final Logger LOG = LoggerFactory.getLogger(MDCService.class);
    private CamelContext camelContext;
    private String customHeaders;
    private String customProperties;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(String customHeaders) {
        this.customHeaders = customHeaders;
    }

    public String getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(String customProperties) {
        this.customProperties = customProperties;
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public void doInit() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getCamelContextExtension().addLogListener((LogListener)new MDCLogListener());
        MDCProcessorsInterceptStrategy interceptStrategy = new MDCProcessorsInterceptStrategy(this);
        this.camelContext.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)interceptStrategy);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Mapped Diagnostic Context (MDC) enabled");
    }

    protected void setMDC(Exchange exchange) {
        try {
            this.prepareMDC(exchange);
            if (this.getCustomHeaders() != null) {
                if (this.getCustomHeaders().equals("*")) {
                    this.allHeadersMDC(exchange);
                } else {
                    this.userSelectedHeadersMDC(exchange);
                }
            }
            if (this.getCustomProperties() != null) {
                if (this.getCustomProperties().equals("*")) {
                    this.allPropertiesMDC(exchange);
                } else {
                    this.userSelectedPropertiesMDC(exchange);
                }
            }
        }
        catch (Exception t) {
            LOG.warn("MDC: failed to store MDC data. This exception is ignored.", (Throwable)t);
        }
    }

    public void unsetMDC() {
        MDC.clear();
    }

    private void prepareMDC(Exchange exchange) {
        String routeId;
        String breadcrumbId;
        MDC.put((String)MDC_EXCHANGE_ID, (String)exchange.getExchangeId());
        MDC.put((String)MDC_MESSAGE_ID, (String)exchange.getMessage().getMessageId());
        MDC.put((String)MDC_CAMEL_CONTEXT_ID, (String)exchange.getContext().getName());
        MDC.put((String)MDC_CAMEL_THREAD_ID, (String)Thread.currentThread().getName());
        String corrId = (String)exchange.getProperty(ExchangePropertyKey.CORRELATION_ID, String.class);
        if (corrId != null) {
            MDC.put((String)MDC_CORRELATION_ID, (String)corrId);
        }
        if ((breadcrumbId = (String)exchange.getIn().getHeader("breadcrumbId", String.class)) != null) {
            MDC.put((String)MDC_BREADCRUMB_ID, (String)breadcrumbId);
        }
        if ((routeId = exchange.getFromRouteId()) != null) {
            MDC.put((String)MDC_ROUTE_ID, (String)routeId);
        }
    }

    private void userSelectedHeadersMDC(Exchange exchange) {
        for (String customHeader : this.getCustomHeaders().split(",")) {
            if (exchange.getIn().getHeader(customHeader) == null) continue;
            MDC.put((String)customHeader, (String)((String)exchange.getIn().getHeader(customHeader, String.class)));
        }
    }

    private void allHeadersMDC(Exchange exchange) {
        for (String header : exchange.getIn().getHeaders().keySet()) {
            if (exchange.getIn().getHeader(header) == null) continue;
            MDC.put((String)header, (String)((String)exchange.getIn().getHeader(header, String.class)));
        }
    }

    private void userSelectedPropertiesMDC(Exchange exchange) {
        for (String customProperty : this.getCustomProperties().split(",")) {
            if (exchange.getProperty(customProperty) == null) continue;
            MDC.put((String)customProperty, (String)((String)exchange.getProperty(customProperty, String.class)));
        }
    }

    private void allPropertiesMDC(Exchange exchange) {
        for (String property : exchange.getAllProperties().keySet()) {
            if (exchange.getProperty(property) == null) continue;
            MDC.put((String)property, (String)((String)exchange.getProperty(property, String.class)));
        }
    }

    private final class MDCLogListener
    implements LogListener {
        private MDCLogListener() {
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            MDCService.this.setMDC(exchange);
            return message;
        }

        public void afterLog(Exchange exchange, CamelLogger camelLogger, String message) {
            MDCService.this.unsetMDC();
        }
    }
}

