/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.mdc;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.mdc.MDCService;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.AsyncProcessorConverterHelper;

public class MDCProcessorsInterceptStrategy
implements InterceptStrategy {
    private MDCService mdcService;

    public MDCProcessorsInterceptStrategy(MDCService mdcService) {
        this.mdcService = mdcService;
    }

    public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) throws Exception {
        final AsyncProcessor asyncProcessor = AsyncProcessorConverterHelper.convert((Processor)target);
        return new AsyncProcessor(){

            public boolean process(Exchange exchange, AsyncCallback callback) {
                MDCProcessorsInterceptStrategy.this.mdcService.setMDC(exchange);
                return asyncProcessor.process(exchange, doneSync -> {
                    MDCProcessorsInterceptStrategy.this.mdcService.unsetMDC();
                    callback.done(doneSync);
                });
            }

            public void process(Exchange exchange) throws Exception {
                MDCProcessorsInterceptStrategy.this.mdcService.setMDC(exchange);
                try {
                    asyncProcessor.process(exchange);
                }
                finally {
                    MDCProcessorsInterceptStrategy.this.mdcService.unsetMDC();
                }
            }

            public CompletableFuture<Exchange> processAsync(Exchange exchange) {
                CompletableFuture<Exchange> future = new CompletableFuture<Exchange>();
                MDCProcessorsInterceptStrategy.this.mdcService.setMDC(exchange);
                asyncProcessor.process(exchange, doneSync -> {
                    if (exchange.getException() != null) {
                        future.completeExceptionally(exchange.getException());
                    } else {
                        future.complete(exchange);
                    }
                    MDCProcessorsInterceptStrategy.this.mdcService.unsetMDC();
                });
                return future;
            }
        };
    }
}

