/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedRandomLoadBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.loadbalancer.RandomLoadBalancer;

@ManagedResource(description="Managed Random LoadBalancer")
public class ManagedRandomLoadBalancer
extends ManagedProcessor
implements ManagedRandomLoadBalancerMBean {
    private final RandomLoadBalancer processor;

    public ManagedRandomLoadBalancer(CamelContext context, RandomLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
        this.processor = processor;
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    public Integer getSize() {
        return this.processor.getProcessors().size();
    }

    public String getLastChosenProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition output;
        int idx = this.processor.getLastChosenProcessorIndex();
        if (idx != -1 && (output = (ProcessorDefinition)(def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }
}

