/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.ThreadPoolConfigurationProperties;
import org.apache.camel.main.ThreadPoolProfileConfigurationProperties;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainSupportModelConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(MainSupportModelConfigurer.class);

    private MainSupportModelConfigurer() {
    }

    static void configureModelCamelContext(CamelContext camelContext, MainConfigurationProperties mainConfigurationProperties, OrderedLocationProperties autoConfiguredProperties, OrderedLocationProperties resilience4jProperties, OrderedLocationProperties faultToleranceProperties) throws Exception {
        ModelCamelContext model = (ModelCamelContext)camelContext;
        if (!resilience4jProperties.isEmpty() || mainConfigurationProperties.hasResilience4jConfiguration()) {
            Resilience4jConfigurationProperties resilience4j = mainConfigurationProperties.resilience4j();
            LOG.debug("Auto-configuring Resilience4j Circuit Breaker EIP from loaded properties: {}", (Object)resilience4jProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, resilience4j, resilience4jProperties, "camel.resilience4j.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            Resilience4jConfigurationDefinition resilience4jModel = model.getResilience4jConfiguration(null);
            if (resilience4jModel == null) {
                resilience4jModel = new Resilience4jConfigurationDefinition();
                model.setResilience4jConfiguration(resilience4jModel);
            }
            MainHelper.setPropertiesOnTarget(camelContext, resilience4jModel, resilience4j);
        }
        if (!faultToleranceProperties.isEmpty() || mainConfigurationProperties.hasFaultToleranceConfiguration()) {
            FaultToleranceConfigurationProperties faultTolerance = mainConfigurationProperties.faultTolerance();
            LOG.debug("Auto-configuring MicroProfile Fault Tolerance Circuit Breaker EIP from loaded properties: {}", (Object)faultToleranceProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, faultTolerance, faultToleranceProperties, "camel.faulttolerance.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            FaultToleranceConfigurationDefinition faultToleranceModel = model.getFaultToleranceConfiguration(null);
            if (faultToleranceModel == null) {
                faultToleranceModel = new FaultToleranceConfigurationDefinition();
                model.setFaultToleranceConfiguration(faultToleranceModel);
            }
            MainHelper.setPropertiesOnTarget(camelContext, faultToleranceModel, faultTolerance);
        }
    }

    static void setVariableProperties(CamelContext camelContext, OrderedLocationProperties variableProperties, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        for (String key : variableProperties.stringPropertyNames()) {
            Object val;
            String value = variableProperties.getProperty(key);
            String id = "global";
            if (key.startsWith("route.")) {
                id = "route";
                key = key.substring(6);
                key = StringHelper.replaceFirst((String)key, (String)".", (String)":");
            } else if (key.startsWith("global.")) {
                id = "global";
                key = key.substring(7);
                key = StringHelper.replaceFirst((String)key, (String)".", (String)":");
            }
            VariableRepository repo = ((VariableRepositoryFactory)camelContext.getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class)).getVariableRepository(id);
            if (value.startsWith("resource:") && ResourceHelper.hasScheme((String)(value = value.substring(9)))) {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)value);
                value = IOHelper.loadText((InputStream)is);
                IOHelper.close((Closeable)is);
            }
            if (StringHelper.isDigit((String)value)) {
                val = camelContext.getTypeConverter().tryConvertTo(Integer.class, (Object)value);
                if (val == null) {
                    val = camelContext.getTypeConverter().tryConvertTo(Long.class, (Object)value);
                }
            } else {
                val = camelContext.getTypeConverter().tryConvertTo(Boolean.class, (Object)value);
            }
            if (val == null) {
                val = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)value);
            }
            repo.setVariable(key, val);
        }
        for (Map.Entry e : variableProperties.entrySet()) {
            String loc = variableProperties.getLocation(e.getKey());
            autoConfiguredProperties.put(loc, (Object)("camel.variable." + String.valueOf(e.getKey())), e.getValue());
        }
    }

    static void setThreadPoolProperties(CamelContext camelContext, MainConfigurationProperties mainConfigurationProperties, OrderedLocationProperties threadPoolProperties, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        ThreadPoolConfigurationProperties tp = mainConfigurationProperties.threadPool();
        Map hcConfig = PropertiesHelper.extractProperties((Map)threadPoolProperties.asMap(), (String)"config", (boolean)false);
        HashMap<String, ThreadPoolProfileConfigurationProperties> tpConfigs = new HashMap<String, ThreadPoolProfileConfigurationProperties>();
        for (Map.Entry entry : hcConfig.entrySet()) {
            ThreadPoolProfileConfigurationProperties tcp;
            String id = StringHelper.between((String)((String)entry.getKey()), (String)"[", (String)"]");
            if (id == null || (tcp = (ThreadPoolProfileConfigurationProperties)tpConfigs.get(id)) != null) continue;
            tcp = new ThreadPoolProfileConfigurationProperties();
            tcp.setId(id);
            tpConfigs.put(id, tcp);
        }
        if (tp.getConfig() != null) {
            tp.getConfig().putAll(tpConfigs);
        } else {
            tp.setConfig(tpConfigs);
        }
        MainHelper.setPropertiesOnTarget(camelContext, tp, threadPoolProperties, "camel.threadpool.", mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        ThreadPoolProfile dp = new ThreadPoolProfileBuilder("default").poolSize(tp.getPoolSize()).maxPoolSize(tp.getMaxPoolSize()).keepAliveTime(tp.getKeepAliveTime(), tp.getTimeUnit()).maxQueueSize(tp.getMaxQueueSize()).allowCoreThreadTimeOut(tp.getAllowCoreThreadTimeOut()).rejectedPolicy(tp.getRejectedPolicy()).build();
        for (ThreadPoolProfileConfigurationProperties config : tp.getConfig().values()) {
            ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder(config.getId(), dp);
            ThreadPoolProfile tpp = builder.poolSize(config.getPoolSize()).maxPoolSize(config.getMaxPoolSize()).keepAliveTime(config.getKeepAliveTime(), config.getTimeUnit()).maxQueueSize(config.getMaxQueueSize()).allowCoreThreadTimeOut(config.getAllowCoreThreadTimeOut()).rejectedPolicy(config.getRejectedPolicy()).build();
            if (tpp.isEmpty()) continue;
            camelContext.getExecutorServiceManager().registerThreadPoolProfile(tpp);
        }
        if (!dp.isEmpty()) {
            dp.setDefaultProfile(Boolean.valueOf(true));
            camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(dp);
        }
    }
}

