/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.TemporaryQueueResolver;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private JmsConfiguration getOrCreateConfiguration(JmsComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new JmsConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JmsComponent target = (JmsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                this.getOrCreateConfiguration(target).setAcceptMessagesWhileStopping((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                this.getOrCreateConfiguration(target).setAcknowledgementModeName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                this.getOrCreateConfiguration(target).setAllowAdditionalHeaders((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowautowiredconnectionfactory": 
            case "allowAutoWiredConnectionFactory": {
                target.setAllowAutoWiredConnectionFactory((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowautowireddestinationresolver": 
            case "allowAutoWiredDestinationResolver": {
                target.setAllowAutoWiredDestinationResolver((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allownullbody": 
            case "allowNullBody": {
                this.getOrCreateConfiguration(target).setAllowNullBody((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                this.getOrCreateConfiguration(target).setAllowReplyManagerQuickStop((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                this.getOrCreateConfiguration(target).setAllowSerializedHeaders((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                this.getOrCreateConfiguration(target).setAlwaysCopyMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "artemisconsumerpriority": 
            case "artemisConsumerPriority": {
                this.getOrCreateConfiguration(target).setArtemisConsumerPriority((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                this.getOrCreateConfiguration(target).setArtemisStreamingEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                this.getOrCreateConfiguration(target).setAsyncConsumer((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                this.getOrCreateConfiguration(target).setAsyncStartListener((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                this.getOrCreateConfiguration(target).setAsyncStopListener((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autostartup": 
            case "autoStartup": {
                this.getOrCreateConfiguration(target).setAutoStartup((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "browselimit": 
            case "browseLimit": {
                this.getOrCreateConfiguration(target).setBrowseLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "cachelevel": 
            case "cacheLevel": {
                this.getOrCreateConfiguration(target).setCacheLevel((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                this.getOrCreateConfiguration(target).setCacheLevelName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                this.getOrCreateConfiguration(target).setConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((JmsConfiguration)JmsComponentConfigurer.property((CamelContext)camelContext, JmsConfiguration.class, (Object)value));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                this.getOrCreateConfiguration(target).setConnectionFactory((ConnectionFactory)JmsComponentConfigurer.property((CamelContext)camelContext, ConnectionFactory.class, (Object)value));
                return true;
            }
            case "consumertype": 
            case "consumerType": {
                this.getOrCreateConfiguration(target).setConsumerType((ConsumerType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, ConsumerType.class, (Object)value)));
                return true;
            }
            case "correlationproperty": 
            case "correlationProperty": {
                this.getOrCreateConfiguration(target).setCorrelationProperty((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                this.getOrCreateConfiguration(target).setDefaultTaskExecutorType((DefaultTaskExecutorType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, DefaultTaskExecutorType.class, (Object)value)));
                return true;
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                this.getOrCreateConfiguration(target).setDeliveryDelay((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "deliverymode": 
            case "deliveryMode": {
                this.getOrCreateConfiguration(target).setDeliveryMode((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                this.getOrCreateConfiguration(target).setDeliveryPersistent((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "destinationresolver": 
            case "destinationResolver": {
                this.getOrCreateConfiguration(target).setDestinationResolver((DestinationResolver)JmsComponentConfigurer.property((CamelContext)camelContext, DestinationResolver.class, (Object)value));
                return true;
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                this.getOrCreateConfiguration(target).setDisableReplyTo((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                this.getOrCreateConfiguration(target).setDisableTimeToLive((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                this.getOrCreateConfiguration(target).setDurableSubscriptionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                this.getOrCreateConfiguration(target).setEagerLoadingOfProperties((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                this.getOrCreateConfiguration(target).setEagerPoisonBody((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "errorhandler": 
            case "errorHandler": {
                this.getOrCreateConfiguration(target).setErrorHandler((ErrorHandler)JmsComponentConfigurer.property((CamelContext)camelContext, ErrorHandler.class, (Object)value));
                return true;
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                this.getOrCreateConfiguration(target).setErrorHandlerLogStackTrace((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                this.getOrCreateConfiguration(target).setErrorHandlerLoggingLevel((LoggingLevel)JmsComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                this.getOrCreateConfiguration(target).setExceptionListener((ExceptionListener)JmsComponentConfigurer.property((CamelContext)camelContext, ExceptionListener.class, (Object)value));
                return true;
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                this.getOrCreateConfiguration(target).setExplicitQosEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                this.getOrCreateConfiguration(target).setExposeListenerSession((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                this.getOrCreateConfiguration(target).setForceSendOriginalMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                this.getOrCreateConfiguration(target).setFormatDateHeadersToIso8601((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                this.getOrCreateConfiguration(target).setIdleConsumerLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "idlereceivespertasklimit": 
            case "idleReceivesPerTaskLimit": {
                this.getOrCreateConfiguration(target).setIdleReceivesPerTaskLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                this.getOrCreateConfiguration(target).setIdleTaskExecutionLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                this.getOrCreateConfiguration(target).setIncludeAllJMSXProperties((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includecorrelationidasbytes": 
            case "includeCorrelationIDAsBytes": {
                target.setIncludeCorrelationIDAsBytes((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                this.getOrCreateConfiguration(target).setIncludeSentJMSMessageID((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                this.getOrCreateConfiguration(target).setJmsKeyFormatStrategy((JmsKeyFormatStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, JmsKeyFormatStrategy.class, (Object)value));
                return true;
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                this.getOrCreateConfiguration(target).setJmsMessageType((JmsMessageType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, JmsMessageType.class, (Object)value)));
                return true;
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                this.getOrCreateConfiguration(target).setLazyCreateTransactionManager((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                this.getOrCreateConfiguration(target).setMapJmsMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                this.getOrCreateConfiguration(target).setMaxMessagesPerTask((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messageconverter": 
            case "messageConverter": {
                this.getOrCreateConfiguration(target).setMessageConverter((MessageConverter)JmsComponentConfigurer.property((CamelContext)camelContext, MessageConverter.class, (Object)value));
                return true;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                this.getOrCreateConfiguration(target).setMessageCreatedStrategy((MessageCreatedStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, MessageCreatedStrategy.class, (Object)value));
                return true;
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                this.getOrCreateConfiguration(target).setMessageIdEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                this.getOrCreateConfiguration(target).setMessageListenerContainerFactory((MessageListenerContainerFactory)JmsComponentConfigurer.property((CamelContext)camelContext, MessageListenerContainerFactory.class, (Object)value));
                return true;
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                this.getOrCreateConfiguration(target).setMessageTimestampEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                this.getOrCreateConfiguration(target).setPreserveMessageQos((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "priority": {
                this.getOrCreateConfiguration(target).setPriority((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                this.getOrCreateConfiguration(target).setPubSubNoLocal((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "queuebrowsestrategy": 
            case "queueBrowseStrategy": {
                target.setQueueBrowseStrategy((QueueBrowseStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, QueueBrowseStrategy.class, (Object)value));
                return true;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                this.getOrCreateConfiguration(target).setReceiveTimeout(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                this.getOrCreateConfiguration(target).setRecoveryInterval(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "replycorrelationproperty": 
            case "replyCorrelationProperty": {
                this.getOrCreateConfiguration(target).setReplyCorrelationProperty((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replyto": 
            case "replyTo": {
                this.getOrCreateConfiguration(target).setReplyTo((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                this.getOrCreateConfiguration(target).setReplyToCacheLevelName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytoconsumertype": 
            case "replyToConsumerType": {
                this.getOrCreateConfiguration(target).setReplyToConsumerType((ConsumerType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, ConsumerType.class, (Object)value)));
                return true;
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                this.getOrCreateConfiguration(target).setReplyToDeliveryPersistent((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                this.getOrCreateConfiguration(target).setReplyToDestinationSelectorName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToOnTimeoutMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytooverride": 
            case "replyToOverride": {
                this.getOrCreateConfiguration(target).setReplyToOverride((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                this.getOrCreateConfiguration(target).setReplyToSameDestinationAllowed((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytotype": 
            case "replyToType": {
                this.getOrCreateConfiguration(target).setReplyToType((ReplyToType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, ReplyToType.class, (Object)value)));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                this.getOrCreateConfiguration(target).setRequestTimeoutCheckerInterval(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "selector": {
                this.getOrCreateConfiguration(target).setSelector((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                target.setServiceLocationEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                this.getOrCreateConfiguration(target).setStreamMessageTypeEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                this.getOrCreateConfiguration(target).setSubscriptionDurable((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                this.getOrCreateConfiguration(target).setSubscriptionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                this.getOrCreateConfiguration(target).setSubscriptionShared((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                this.getOrCreateConfiguration(target).setSynchronous((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "taskexecutor": 
            case "taskExecutor": {
                this.getOrCreateConfiguration(target).setTaskExecutor((TaskExecutor)JmsComponentConfigurer.property((CamelContext)camelContext, TaskExecutor.class, (Object)value));
                return true;
            }
            case "temporaryqueueresolver": 
            case "temporaryQueueResolver": {
                this.getOrCreateConfiguration(target).setTemporaryQueueResolver((TemporaryQueueResolver)JmsComponentConfigurer.property((CamelContext)camelContext, TemporaryQueueResolver.class, (Object)value));
                return true;
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                this.getOrCreateConfiguration(target).setTestConnectionOnStartup((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                this.getOrCreateConfiguration(target).setTimeToLive((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "transacted": {
                this.getOrCreateConfiguration(target).setTransacted((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transactedinout": 
            case "transactedInOut": {
                this.getOrCreateConfiguration(target).setTransactedInOut((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transactionmanager": 
            case "transactionManager": {
                this.getOrCreateConfiguration(target).setTransactionManager((PlatformTransactionManager)JmsComponentConfigurer.property((CamelContext)camelContext, PlatformTransactionManager.class, (Object)value));
                return true;
            }
            case "transactionname": 
            case "transactionName": {
                this.getOrCreateConfiguration(target).setTransactionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                this.getOrCreateConfiguration(target).setTransactionTimeout((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "transferexception": 
            case "transferException": {
                this.getOrCreateConfiguration(target).setTransferException((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                this.getOrCreateConfiguration(target).setTransferExchange((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                this.getOrCreateConfiguration(target).setUseMessageIDAsCorrelationID((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                this.getOrCreateConfiguration(target).setWaitForProvisionCorrelationToBeUpdatedCounter((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                this.getOrCreateConfiguration(target).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
            case "waitfortemporaryreplytotobeupdatedcounter": 
            case "waitForTemporaryReplyToToBeUpdatedCounter": {
                this.getOrCreateConfiguration(target).setWaitForTemporaryReplyToToBeUpdatedCounter((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "waitfortemporaryreplytotobeupdatedthreadsleepingtime": 
            case "waitForTemporaryReplyToToBeUpdatedThreadSleepingTime": {
                this.getOrCreateConfiguration(target).setWaitForTemporaryReplyToToBeUpdatedThreadSleepingTime(((Duration)JmsComponentConfigurer.property((CamelContext)camelContext, Duration.class, (Object)value)).toMillis());
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                return Boolean.TYPE;
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                return String.class;
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                return String.class;
            }
            case "allowautowiredconnectionfactory": 
            case "allowAutoWiredConnectionFactory": {
                return Boolean.TYPE;
            }
            case "allowautowireddestinationresolver": 
            case "allowAutoWiredDestinationResolver": {
                return Boolean.TYPE;
            }
            case "allownullbody": 
            case "allowNullBody": {
                return Boolean.TYPE;
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                return Boolean.TYPE;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return Boolean.TYPE;
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                return Boolean.TYPE;
            }
            case "artemisconsumerpriority": 
            case "artemisConsumerPriority": {
                return Integer.TYPE;
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                return Boolean.TYPE;
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                return Boolean.TYPE;
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                return Boolean.TYPE;
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                return Boolean.TYPE;
            }
            case "autostartup": 
            case "autoStartup": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "browselimit": 
            case "browseLimit": {
                return Integer.TYPE;
            }
            case "cachelevel": 
            case "cacheLevel": {
                return Integer.TYPE;
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                return String.class;
            }
            case "clientid": 
            case "clientId": {
                return String.class;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return Integer.TYPE;
            }
            case "configuration": {
                return JmsConfiguration.class;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return ConnectionFactory.class;
            }
            case "consumertype": 
            case "consumerType": {
                return ConsumerType.class;
            }
            case "correlationproperty": 
            case "correlationProperty": {
                return String.class;
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                return DefaultTaskExecutorType.class;
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                return Long.TYPE;
            }
            case "deliverymode": 
            case "deliveryMode": {
                return Integer.class;
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                return Boolean.TYPE;
            }
            case "destinationresolver": 
            case "destinationResolver": {
                return DestinationResolver.class;
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                return Boolean.TYPE;
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                return Boolean.TYPE;
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                return String.class;
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                return Boolean.TYPE;
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                return String.class;
            }
            case "errorhandler": 
            case "errorHandler": {
                return ErrorHandler.class;
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                return Boolean.TYPE;
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                return LoggingLevel.class;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return ExceptionListener.class;
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                return Boolean.class;
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                return Boolean.TYPE;
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                return Boolean.TYPE;
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                return Boolean.TYPE;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                return Integer.TYPE;
            }
            case "idlereceivespertasklimit": 
            case "idleReceivesPerTaskLimit": {
                return Integer.TYPE;
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                return Integer.TYPE;
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                return Boolean.TYPE;
            }
            case "includecorrelationidasbytes": 
            case "includeCorrelationIDAsBytes": {
                return Boolean.TYPE;
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                return Boolean.TYPE;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return JmsKeyFormatStrategy.class;
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                return JmsMessageType.class;
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                return Boolean.TYPE;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                return Integer.TYPE;
            }
            case "messageconverter": 
            case "messageConverter": {
                return MessageConverter.class;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return MessageCreatedStrategy.class;
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                return Boolean.TYPE;
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                return MessageListenerContainerFactory.class;
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                return Boolean.TYPE;
            }
            case "priority": {
                return Integer.TYPE;
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                return Boolean.TYPE;
            }
            case "queuebrowsestrategy": 
            case "queueBrowseStrategy": {
                return QueueBrowseStrategy.class;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return Long.TYPE;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return Long.TYPE;
            }
            case "replycorrelationproperty": 
            case "replyCorrelationProperty": {
                return String.class;
            }
            case "replyto": 
            case "replyTo": {
                return String.class;
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                return String.class;
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "replytoconsumertype": 
            case "replyToConsumerType": {
                return ConsumerType.class;
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                return Boolean.TYPE;
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                return String.class;
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "replytooverride": 
            case "replyToOverride": {
                return String.class;
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                return Boolean.TYPE;
            }
            case "replytotype": 
            case "replyToType": {
                return ReplyToType.class;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return Long.TYPE;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return Long.TYPE;
            }
            case "selector": {
                return String.class;
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                return Boolean.TYPE;
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                return Boolean.TYPE;
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                return Boolean.TYPE;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return String.class;
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                return Boolean.TYPE;
            }
            case "synchronous": {
                return Boolean.TYPE;
            }
            case "taskexecutor": 
            case "taskExecutor": {
                return TaskExecutor.class;
            }
            case "temporaryqueueresolver": 
            case "temporaryQueueResolver": {
                return TemporaryQueueResolver.class;
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                return Boolean.TYPE;
            }
            case "timetolive": 
            case "timeToLive": {
                return Long.TYPE;
            }
            case "transacted": {
                return Boolean.TYPE;
            }
            case "transactedinout": 
            case "transactedInOut": {
                return Boolean.TYPE;
            }
            case "transactionmanager": 
            case "transactionManager": {
                return PlatformTransactionManager.class;
            }
            case "transactionname": 
            case "transactionName": {
                return String.class;
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                return Integer.TYPE;
            }
            case "transferexception": 
            case "transferException": {
                return Boolean.TYPE;
            }
            case "transferexchange": 
            case "transferExchange": {
                return Boolean.TYPE;
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                return Integer.TYPE;
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                return Long.TYPE;
            }
            case "waitfortemporaryreplytotobeupdatedcounter": 
            case "waitForTemporaryReplyToToBeUpdatedCounter": {
                return Integer.TYPE;
            }
            case "waitfortemporaryreplytotobeupdatedthreadsleepingtime": 
            case "waitForTemporaryReplyToToBeUpdatedThreadSleepingTime": {
                return Long.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JmsComponent target = (JmsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                return this.getOrCreateConfiguration(target).isAcceptMessagesWhileStopping();
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                return this.getOrCreateConfiguration(target).getAcknowledgementModeName();
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                return this.getOrCreateConfiguration(target).getAllowAdditionalHeaders();
            }
            case "allowautowiredconnectionfactory": 
            case "allowAutoWiredConnectionFactory": {
                return target.isAllowAutoWiredConnectionFactory();
            }
            case "allowautowireddestinationresolver": 
            case "allowAutoWiredDestinationResolver": {
                return target.isAllowAutoWiredDestinationResolver();
            }
            case "allownullbody": 
            case "allowNullBody": {
                return this.getOrCreateConfiguration(target).isAllowNullBody();
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                return this.getOrCreateConfiguration(target).isAllowReplyManagerQuickStop();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return this.getOrCreateConfiguration(target).isAllowSerializedHeaders();
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                return this.getOrCreateConfiguration(target).isAlwaysCopyMessage();
            }
            case "artemisconsumerpriority": 
            case "artemisConsumerPriority": {
                return this.getOrCreateConfiguration(target).getArtemisConsumerPriority();
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                return this.getOrCreateConfiguration(target).isArtemisStreamingEnabled();
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                return this.getOrCreateConfiguration(target).isAsyncConsumer();
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                return this.getOrCreateConfiguration(target).isAsyncStartListener();
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                return this.getOrCreateConfiguration(target).isAsyncStopListener();
            }
            case "autostartup": 
            case "autoStartup": {
                return this.getOrCreateConfiguration(target).isAutoStartup();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "browselimit": 
            case "browseLimit": {
                return this.getOrCreateConfiguration(target).getBrowseLimit();
            }
            case "cachelevel": 
            case "cacheLevel": {
                return this.getOrCreateConfiguration(target).getCacheLevel();
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                return this.getOrCreateConfiguration(target).getCacheLevelName();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return this.getOrCreateConfiguration(target).getConcurrentConsumers();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return this.getOrCreateConfiguration(target).getConnectionFactory();
            }
            case "consumertype": 
            case "consumerType": {
                return this.getOrCreateConfiguration(target).getConsumerType();
            }
            case "correlationproperty": 
            case "correlationProperty": {
                return this.getOrCreateConfiguration(target).getCorrelationProperty();
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                return this.getOrCreateConfiguration(target).getDefaultTaskExecutorType();
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                return this.getOrCreateConfiguration(target).getDeliveryDelay();
            }
            case "deliverymode": 
            case "deliveryMode": {
                return this.getOrCreateConfiguration(target).getDeliveryMode();
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                return this.getOrCreateConfiguration(target).isDeliveryPersistent();
            }
            case "destinationresolver": 
            case "destinationResolver": {
                return this.getOrCreateConfiguration(target).getDestinationResolver();
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                return this.getOrCreateConfiguration(target).isDisableReplyTo();
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                return this.getOrCreateConfiguration(target).isDisableTimeToLive();
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                return this.getOrCreateConfiguration(target).getDurableSubscriptionName();
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                return this.getOrCreateConfiguration(target).isEagerLoadingOfProperties();
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                return this.getOrCreateConfiguration(target).getEagerPoisonBody();
            }
            case "errorhandler": 
            case "errorHandler": {
                return this.getOrCreateConfiguration(target).getErrorHandler();
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                return this.getOrCreateConfiguration(target).isErrorHandlerLogStackTrace();
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                return this.getOrCreateConfiguration(target).getErrorHandlerLoggingLevel();
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return this.getOrCreateConfiguration(target).getExceptionListener();
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                return this.getOrCreateConfiguration(target).getExplicitQosEnabled();
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                return this.getOrCreateConfiguration(target).isExposeListenerSession();
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                return this.getOrCreateConfiguration(target).isForceSendOriginalMessage();
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                return this.getOrCreateConfiguration(target).isFormatDateHeadersToIso8601();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                return this.getOrCreateConfiguration(target).getIdleConsumerLimit();
            }
            case "idlereceivespertasklimit": 
            case "idleReceivesPerTaskLimit": {
                return this.getOrCreateConfiguration(target).getIdleReceivesPerTaskLimit();
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                return this.getOrCreateConfiguration(target).getIdleTaskExecutionLimit();
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                return this.getOrCreateConfiguration(target).isIncludeAllJMSXProperties();
            }
            case "includecorrelationidasbytes": 
            case "includeCorrelationIDAsBytes": {
                return target.isIncludeCorrelationIDAsBytes();
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                return this.getOrCreateConfiguration(target).isIncludeSentJMSMessageID();
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return this.getOrCreateConfiguration(target).getJmsKeyFormatStrategy();
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                return this.getOrCreateConfiguration(target).getJmsMessageType();
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                return this.getOrCreateConfiguration(target).isLazyCreateTransactionManager();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                return this.getOrCreateConfiguration(target).isMapJmsMessage();
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getMaxConcurrentConsumers();
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                return this.getOrCreateConfiguration(target).getMaxMessagesPerTask();
            }
            case "messageconverter": 
            case "messageConverter": {
                return this.getOrCreateConfiguration(target).getMessageConverter();
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return this.getOrCreateConfiguration(target).getMessageCreatedStrategy();
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                return this.getOrCreateConfiguration(target).isMessageIdEnabled();
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                return this.getOrCreateConfiguration(target).getMessageListenerContainerFactory();
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                return this.getOrCreateConfiguration(target).isMessageTimestampEnabled();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                return this.getOrCreateConfiguration(target).isPreserveMessageQos();
            }
            case "priority": {
                return this.getOrCreateConfiguration(target).getPriority();
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                return this.getOrCreateConfiguration(target).isPubSubNoLocal();
            }
            case "queuebrowsestrategy": 
            case "queueBrowseStrategy": {
                return target.getQueueBrowseStrategy();
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return this.getOrCreateConfiguration(target).getReceiveTimeout();
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return this.getOrCreateConfiguration(target).getRecoveryInterval();
            }
            case "replycorrelationproperty": 
            case "replyCorrelationProperty": {
                return this.getOrCreateConfiguration(target).getReplyCorrelationProperty();
            }
            case "replyto": 
            case "replyTo": {
                return this.getOrCreateConfiguration(target).getReplyTo();
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                return this.getOrCreateConfiguration(target).getReplyToCacheLevelName();
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToConcurrentConsumers();
            }
            case "replytoconsumertype": 
            case "replyToConsumerType": {
                return this.getOrCreateConfiguration(target).getReplyToConsumerType();
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                return this.getOrCreateConfiguration(target).isReplyToDeliveryPersistent();
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                return this.getOrCreateConfiguration(target).getReplyToDestinationSelectorName();
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToMaxConcurrentConsumers();
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToOnTimeoutMaxConcurrentConsumers();
            }
            case "replytooverride": 
            case "replyToOverride": {
                return this.getOrCreateConfiguration(target).getReplyToOverride();
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                return this.getOrCreateConfiguration(target).isReplyToSameDestinationAllowed();
            }
            case "replytotype": 
            case "replyToType": {
                return this.getOrCreateConfiguration(target).getReplyToType();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return this.getOrCreateConfiguration(target).getRequestTimeoutCheckerInterval();
            }
            case "selector": {
                return this.getOrCreateConfiguration(target).getSelector();
            }
            case "servicelocationenabled": 
            case "serviceLocationEnabled": {
                return target.isServiceLocationEnabled();
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                return this.getOrCreateConfiguration(target).isStreamMessageTypeEnabled();
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                return this.getOrCreateConfiguration(target).isSubscriptionDurable();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return this.getOrCreateConfiguration(target).getSubscriptionName();
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                return this.getOrCreateConfiguration(target).isSubscriptionShared();
            }
            case "synchronous": {
                return this.getOrCreateConfiguration(target).isSynchronous();
            }
            case "taskexecutor": 
            case "taskExecutor": {
                return this.getOrCreateConfiguration(target).getTaskExecutor();
            }
            case "temporaryqueueresolver": 
            case "temporaryQueueResolver": {
                return this.getOrCreateConfiguration(target).getTemporaryQueueResolver();
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                return this.getOrCreateConfiguration(target).isTestConnectionOnStartup();
            }
            case "timetolive": 
            case "timeToLive": {
                return this.getOrCreateConfiguration(target).getTimeToLive();
            }
            case "transacted": {
                return this.getOrCreateConfiguration(target).isTransacted();
            }
            case "transactedinout": 
            case "transactedInOut": {
                return this.getOrCreateConfiguration(target).isTransactedInOut();
            }
            case "transactionmanager": 
            case "transactionManager": {
                return this.getOrCreateConfiguration(target).getTransactionManager();
            }
            case "transactionname": 
            case "transactionName": {
                return this.getOrCreateConfiguration(target).getTransactionName();
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                return this.getOrCreateConfiguration(target).getTransactionTimeout();
            }
            case "transferexception": 
            case "transferException": {
                return this.getOrCreateConfiguration(target).isTransferException();
            }
            case "transferexchange": 
            case "transferExchange": {
                return this.getOrCreateConfiguration(target).isTransferExchange();
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                return this.getOrCreateConfiguration(target).isUseMessageIDAsCorrelationID();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                return this.getOrCreateConfiguration(target).getWaitForProvisionCorrelationToBeUpdatedCounter();
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                return this.getOrCreateConfiguration(target).getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
            }
            case "waitfortemporaryreplytotobeupdatedcounter": 
            case "waitForTemporaryReplyToToBeUpdatedCounter": {
                return this.getOrCreateConfiguration(target).getWaitForTemporaryReplyToToBeUpdatedCounter();
            }
            case "waitfortemporaryreplytotobeupdatedthreadsleepingtime": 
            case "waitForTemporaryReplyToToBeUpdatedThreadSleepingTime": {
                return this.getOrCreateConfiguration(target).getWaitForTemporaryReplyToToBeUpdatedThreadSleepingTime();
            }
        }
        return null;
    }
}

