/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.jackson.AbstractJacksonDataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="jackson")
@Metadata(excludeProperties="library,permissions,dateFormatPattern")
public class JacksonDataFormat
extends AbstractJacksonDataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonDataFormat.class);

    public JacksonDataFormat() {
    }

    public JacksonDataFormat(Class<?> unmarshalType) {
        super(unmarshalType);
    }

    public JacksonDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        super(unmarshalType, jsonView);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        super(mapper, unmarshalType);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        super(mapper, unmarshalType, jsonView);
    }

    @Override
    public String getDataFormatName() {
        return "jackson";
    }

    @Override
    protected ObjectMapper createNewObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        int len = this.getMaxStringLength();
        if (len > 0) {
            LOG.debug("Creating ObjectMapper with maxStringLength: {}", (Object)len);
            om.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(len).build());
        }
        return om;
    }

    @Override
    protected Class<? extends ObjectMapper> getObjectMapperClass() {
        return ObjectMapper.class;
    }

    @Override
    protected String getDefaultContentType() {
        return "application/json";
    }
}

