/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class JacksonTypeConverters {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonTypeConverters.class);
    private final Lock lock = new ReentrantLock();
    private volatile ObjectMapper defaultMapper;
    private boolean init;
    private boolean enabled;
    private boolean toPojo;
    private String moduleClassNames;

    @Converter
    public JsonNode toJsonNode(String text, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.readTree(text);
    }

    @Converter
    public JsonNode toJsonNode(byte[] arr, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.readTree(arr);
    }

    @Converter
    public JsonNode toJsonNode(InputStream is, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.readTree(is);
    }

    @Converter
    public JsonNode toJsonNode(File file, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.readTree(file);
    }

    @Converter
    public JsonNode toJsonNode(Reader reader, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.readTree(reader);
    }

    @Converter
    public JsonNode toJsonNode(Map map, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.valueToTree((Object)map);
    }

    @Converter
    public String toString(JsonNode node, Exchange exchange) throws Exception {
        if (node instanceof TextNode) {
            TextNode tn = (TextNode)node;
            return tn.textValue();
        }
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }

    @Converter
    public byte[] toByteArray(JsonNode node, Exchange exchange) throws Exception {
        if (node instanceof TextNode) {
            TextNode tn = (TextNode)node;
            return tn.textValue().getBytes(StandardCharsets.UTF_8);
        }
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return mapper.writeValueAsBytes((Object)node);
    }

    @Converter
    public InputStream toInputStream(JsonNode node, Exchange exchange) throws Exception {
        byte[] arr = this.toByteArray(node, exchange);
        return new ByteArrayInputStream(arr);
    }

    @Converter
    public Map<String, Object> toMap(JsonNode node, Exchange exchange) throws Exception {
        ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
        return (Map)mapper.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Converter
    public Reader toReader(JsonNode node, Exchange exchange) throws Exception {
        InputStream is = this.toInputStream(node, exchange);
        return new InputStreamReader(is);
    }

    @Converter
    public Integer toInteger(JsonNode node, Exchange exchange) throws Exception {
        NumericNode nn;
        if (node instanceof NumericNode && (nn = (NumericNode)node).canConvertToInt()) {
            return nn.asInt();
        }
        String text = node.asText();
        return Integer.valueOf(text);
    }

    @Converter
    public Long toLong(JsonNode node, Exchange exchange) throws Exception {
        NumericNode nn;
        if (node instanceof NumericNode && (nn = (NumericNode)node).canConvertToLong()) {
            return nn.asLong();
        }
        String text = node.asText();
        return Long.valueOf(text);
    }

    @Converter
    public Boolean toBoolean(BooleanNode node, Exchange exchange) throws Exception {
        return node.asBoolean();
    }

    @Converter
    public Boolean toBoolean(JsonNode node, Exchange exchange) throws Exception {
        if (node instanceof BooleanNode) {
            BooleanNode bn = (BooleanNode)node;
            return bn.asBoolean();
        }
        String text = node.asText();
        return ObjectHelper.toBoolean((Object)text);
    }

    @Converter
    public Double toDouble(JsonNode node, Exchange exchange) throws Exception {
        NumericNode nn;
        if (node instanceof NumericNode && (nn = (NumericNode)node).isFloatingPointNumber()) {
            return nn.asDouble();
        }
        String text = node.asText();
        return Double.valueOf(text);
    }

    @Converter
    public Float toFloat(JsonNode node, Exchange exchange) throws Exception {
        NumericNode nn;
        if (node instanceof NumericNode && (nn = (NumericNode)node).isFloat()) {
            return Float.valueOf(nn.floatValue());
        }
        String text = node.asText();
        return Float.valueOf(text);
    }

    @Converter(fallback=true)
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws Exception {
        if (!this.init && exchange != null) {
            this.initialize(exchange);
        }
        if (!this.enabled) {
            return null;
        }
        if (!this.toPojo && JacksonTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (exchange != null) {
            ObjectMapper mapper = this.resolveObjectMapper(exchange.getContext());
            if (String.class.isAssignableFrom(type)) {
                String out = mapper.writeValueAsString(value);
                return type.cast(out);
            }
            if (byte[].class.isAssignableFrom(type)) {
                byte[] out = mapper.writeValueAsBytes(value);
                return type.cast(out);
            }
            if (ByteBuffer.class.isAssignableFrom(type)) {
                byte[] out = mapper.writeValueAsBytes(value);
                return type.cast(ByteBuffer.wrap(out));
            }
            if (mapper.canSerialize(type) && !Enum.class.isAssignableFrom(type)) {
                if (String.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((String)value, type);
                }
                if (byte[].class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((byte[])value, type);
                }
                if (File.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((File)value, type);
                }
                if (InputStream.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((InputStream)value, type);
                }
                if (Reader.class.isAssignableFrom(value.getClass())) {
                    return (T)mapper.readValue((Reader)value, type);
                }
                return (T)mapper.convertValue(value, type);
            }
        }
        return null;
    }

    private void initialize(Exchange exchange) {
        Map globalOptions = exchange.getContext().getGlobalOptions();
        String text = (String)globalOptions.get("CamelJacksonEnableTypeConverter");
        if (text != null) {
            text = exchange.getContext().resolvePropertyPlaceholders(text);
            this.enabled = Boolean.parseBoolean(text);
        }
        if ((text = (String)globalOptions.get("CamelJacksonTypeConverterToPojo")) != null) {
            text = exchange.getContext().resolvePropertyPlaceholders(text);
            this.toPojo = Boolean.parseBoolean(text);
        }
        this.moduleClassNames = (String)globalOptions.get("CamelJacksonTypeConverterModuleClassNames");
        this.init = true;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper resolveObjectMapper(CamelContext camelContext) throws Exception {
        Set mappers = camelContext.getRegistry().findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        if (this.defaultMapper == null) {
            this.lock.lock();
            try {
                if (this.defaultMapper == null) {
                    ObjectMapper mapper = new ObjectMapper();
                    if (this.moduleClassNames != null) {
                        for (Object o : org.apache.camel.support.ObjectHelper.createIterable((String)this.moduleClassNames)) {
                            Class type = camelContext.getClassResolver().resolveMandatoryClass(o.toString(), Module.class);
                            Module module = (Module)camelContext.getInjector().newInstance(type);
                            LOG.debug("Registering module: {} -> {}", o, (Object)module);
                            mapper.registerModule(module);
                        }
                    }
                    this.defaultMapper = mapper;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.defaultMapper;
    }
}

