/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public class PreemptiveAuthExecChainHandler
implements ExecChainHandler {
    private final HttpEndpoint endpoint;

    public PreemptiveAuthExecChainHandler(HttpEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        HttpClientContext context = scope.clientContext;
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            HttpHost httpHost;
            CredentialsProvider credentialsProvider = context.getCredentialsProvider();
            Credentials credentials = credentialsProvider.getCredentials(new AuthScope(httpHost = scope.route.getTargetHost()), (HttpContext)context);
            if (credentials == null) {
                credentials = HttpCredentialsHelper.getCredentials(this.endpoint.getAuthMethod(), this.endpoint.getAuthUsername(), this.endpoint.getAuthPassword(), this.endpoint.getAuthHost(), this.endpoint.getAuthHost());
            }
            if (credentials == null) {
                throw new HttpException("No credentials for preemptive authentication");
            }
            BasicScheme authScheme = new BasicScheme();
            authScheme.initPreemptive(credentials);
            authCache = new BasicAuthCache();
            authCache.put(httpHost, (AuthScheme)authScheme);
            context.setAuthCache(authCache);
        }
        return chain.proceed(request, scope);
    }
}

