/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.HttpClientBuilder;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final String password;
    private final String domain;
    private final String host;
    private final HttpCredentialsHelper credentialsHelper;

    public BasicAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host, HttpCredentialsHelper credentialsHelper) {
        this.username = user;
        this.password = pwd;
        this.domain = domain;
        this.host = host;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.host, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
        clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, null, (Credentials)defaultcreds));
    }
}

