/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;

public abstract class HttpCommonComponent
extends HeaderFilterStrategyComponent {
    @Metadata(label="advanced", description="To use a custom HttpBinding to control the mapping between Camel message and HttpClient.")
    protected HttpBinding httpBinding;
    @Metadata(label="advanced", description="To use the shared HttpConfiguration as base configuration.")
    protected HttpConfiguration httpConfiguration;
    @Metadata(label="consumer", defaultValue="true", description="If enabled and an Exchange failed processing on the consumer side the response's body won't contain the exception's stack trace.")
    protected boolean muteException = true;
    @Metadata(label="advanced", description="Whether to allow java serialization when a request uses context-type=application/x-java-serialized-object. This is by default turned off.  If you enable this then be aware that Java will deserialize the incoming data from the request to Java and that can be a potential security risk.")
    protected boolean allowJavaSerializedObject;

    protected HttpCommonComponent() {
    }

    public <T> T getParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getParameter(parameters, key, type, null);
    }

    public <T> T getParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.get(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return null;
        }
        return (T)CamelContextHelper.convertTo((CamelContext)this.getCamelContext(), type, (Object)value);
    }

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    public boolean canConnect(HttpConsumer consumer) throws Exception {
        return true;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public boolean isAllowJavaSerializedObject() {
        return this.allowJavaSerializedObject;
    }

    public void setAllowJavaSerializedObject(boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }
}

