/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.StopWatch;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpChangedExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<FTPFile> {
    private static final Logger LOG = LoggerFactory.getLogger(FtpChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 5000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    private long minLength = 1L;
    private long minAge;
    private boolean fastExistsCheck;

    public void prepareOnStartup(GenericFileOperations<FTPFile> tGenericFileOperations, GenericFileEndpoint<FTPFile> tGenericFileEndpoint) throws Exception {
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
        boolean exclusive = false;
        LOG.trace("Waiting for exclusive read lock to file: " + file);
        long lastModified = Long.MIN_VALUE;
        long length = Long.MIN_VALUE;
        StopWatch watch = new StopWatch();
        long startTime = new Date().getTime();
        while (!exclusive) {
            List files;
            long delta;
            if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file));
                return false;
            }
            long newLastModified = 0L;
            long newLength = 0L;
            if (this.fastExistsCheck) {
                LOG.trace("Using fast exists to update file information for {}", file);
                files = operations.listFiles(file.getAbsoluteFilePath());
            } else {
                LOG.trace("Using full directory listing to update file information for {}. Consider enabling fastExistsCheck option.", file);
                files = operations.listFiles(file.getParent());
            }
            LOG.trace("List files {} found {} files", (Object)file.getAbsoluteFilePath(), (Object)files.size());
            for (FTPFile f : files) {
                if (!f.getName().equals(file.getFileNameOnly())) continue;
                newLength = f.getSize();
                if (f.getTimestamp() == null) continue;
                newLastModified = f.getTimestamp().getTimeInMillis();
            }
            LOG.trace("Previous last modified: " + lastModified + ", new last modified: " + newLastModified);
            LOG.trace("Previous length: " + length + ", new length: " + newLength);
            long newOlderThan = startTime + watch.taken() - this.minAge;
            LOG.trace("New older than threshold: {}", (Object)newOlderThan);
            if (newLength >= this.minLength && (this.minAge == 0L && newLastModified == lastModified && newLength == length || this.minAge != 0L && newLastModified < newOlderThan)) {
                LOG.trace("Read lock acquired.");
                exclusive = true;
                continue;
            }
            lastModified = newLastModified;
            length = newLength;
            boolean interrupted = this.sleep();
            if (!interrupted) continue;
            return false;
        }
        return exclusive;
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for " + this.checkInterval + " millis.");
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public void setMarkerFiler(boolean markerFiler) {
    }

    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }

    public boolean isFastExistsCheck() {
        return this.fastExistsCheck;
    }

    public void setFastExistsCheck(boolean fastExistsCheck) {
        this.fastExistsCheck = fastExistsCheck;
    }
}

