/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.cluster.FileLockClusterView;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="bean", description="A file based cluster locking (read documentation to understand limitations)", annotations={"interfaceName=org.apache.camel.cluster.CamelClusterService"})
@Configurer(metadataOnly=true)
public class FileLockClusterService
extends AbstractCamelClusterService<FileLockClusterView> {
    private ScheduledExecutorService executor;
    private ExecutorService clusterDataTaskExecutor;
    @Metadata(description="The root file path", required=true)
    private String root;
    @Metadata(description="The time to wait before starting to try to acquire the cluster lock. Note that if FileLockClusterService determines no cluster members are running or cannot reliably determine the cluster state, the initial delay is computed from the acquireLockInterval.", defaultValue="1")
    private long acquireLockDelay = 1L;
    @Metadata(description="The time unit for the acquireLockDelay", defaultValue="SECONDS")
    private TimeUnit acquireLockDelayUnit = TimeUnit.SECONDS;
    @Metadata(description="The time to wait between attempts to try to acquire the cluster lock evaluated using wall-clock time. All cluster members must use the same value so leadership checks and leader liveness detection remain consistent.", defaultValue="10")
    private long acquireLockInterval = 10L;
    @Metadata(description="The time unit for the acquireLockInterval", defaultValue="SECONDS")
    private TimeUnit acquireLockIntervalUnit = TimeUnit.SECONDS;
    @Metadata(description="Multiplier applied to the cluster leader acquireLockInterval to determine how long followers should wait before considering the leader stale. For example, if the leader updates its heartbeat every 2 seconds and the heartbeatTimeoutMultiplier is 3, followers will tolerate up to 2s * 3 = 6s of silence before declaring the leader unavailable.", defaultValue="5")
    private int heartbeatTimeoutMultiplier = 5;
    @Metadata(description="Sets how many times a cluster data task will run, counting both the first execution and subsequent retries in case of failure or timeout. The default is 5 attempts. This can be useful when the cluster data root is on network based file storage, where I/O operations may occasionally block for long or unpredictable periods.", defaultValue="5")
    private int clusterDataTaskMaxAttempts = 5;
    @Metadata(description="Sets the timeout for a cluster data task (reading or writing cluster data). The default is 10 seconds. Timeouts are useful when the cluster data root is on network storage, where I/O operations may occasionally block for long or unpredictable periods.", defaultValue="10")
    private long clusterDataTaskTimeout = 10L;
    @Metadata(description="The time unit for the clusterDataTaskTimeoutUnit", defaultValue="SECONDS")
    private TimeUnit clusterDataTaskTimeoutUnit = TimeUnit.SECONDS;

    protected FileLockClusterView createView(String namespace) throws Exception {
        return new FileLockClusterView(this, namespace);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public long getAcquireLockDelay() {
        return this.acquireLockDelay;
    }

    public void setAcquireLockDelay(long acquireLockDelay) {
        if (acquireLockDelay <= 0L) {
            throw new IllegalArgumentException("acquireLockDelay must be greater than 0");
        }
        this.acquireLockDelay = acquireLockDelay;
    }

    public void setAcquireLockDelay(long pollDelay, TimeUnit pollDelayUnit) {
        this.setAcquireLockDelay(pollDelay);
        this.setAcquireLockDelayUnit(pollDelayUnit);
    }

    public TimeUnit getAcquireLockDelayUnit() {
        return this.acquireLockDelayUnit;
    }

    public void setAcquireLockDelayUnit(TimeUnit acquireLockDelayUnit) {
        this.acquireLockDelayUnit = acquireLockDelayUnit;
    }

    public long getAcquireLockInterval() {
        return this.acquireLockInterval;
    }

    public void setAcquireLockInterval(long acquireLockInterval) {
        if (acquireLockInterval <= 0L) {
            throw new IllegalArgumentException("acquireLockInterval must be greater than 0");
        }
        this.acquireLockInterval = acquireLockInterval;
    }

    public void setAcquireLockInterval(long pollInterval, TimeUnit pollIntervalUnit) {
        this.setAcquireLockInterval(pollInterval);
        this.setAcquireLockIntervalUnit(pollIntervalUnit);
    }

    public TimeUnit getAcquireLockIntervalUnit() {
        return this.acquireLockIntervalUnit;
    }

    public void setAcquireLockIntervalUnit(TimeUnit acquireLockIntervalUnit) {
        this.acquireLockIntervalUnit = acquireLockIntervalUnit;
    }

    public void setHeartbeatTimeoutMultiplier(int heartbeatTimeoutMultiplier) {
        if (heartbeatTimeoutMultiplier <= 0) {
            throw new IllegalArgumentException("HeartbeatTimeoutMultiplier must be greater than 0");
        }
        this.heartbeatTimeoutMultiplier = heartbeatTimeoutMultiplier;
    }

    public int getHeartbeatTimeoutMultiplier() {
        return this.heartbeatTimeoutMultiplier;
    }

    public void setClusterDataTaskMaxAttempts(int clusterDataTaskMaxAttempts) {
        if (clusterDataTaskMaxAttempts <= 0) {
            throw new IllegalArgumentException("clusterDataTaskMaxRetries must be greater than 0");
        }
        this.clusterDataTaskMaxAttempts = clusterDataTaskMaxAttempts;
    }

    public int getClusterDataTaskMaxAttempts() {
        return this.clusterDataTaskMaxAttempts;
    }

    public void setClusterDataTaskTimeout(long clusterDataTaskTimeout) {
        if (clusterDataTaskTimeout <= 0L) {
            throw new IllegalArgumentException("clusterDataTaskMaxRetries must be greater than 0");
        }
        this.clusterDataTaskTimeout = clusterDataTaskTimeout;
    }

    public long getClusterDataTaskTimeout() {
        return this.clusterDataTaskTimeout;
    }

    public void setClusterDataTaskTimeoutUnit(TimeUnit clusterDataTaskTimeoutUnit) {
        this.clusterDataTaskTimeoutUnit = clusterDataTaskTimeoutUnit;
    }

    public TimeUnit getClusterDataTaskTimeoutUnit() {
        return this.clusterDataTaskTimeoutUnit;
    }

    public void setClusterDataTaskTimeout(long clusterDataTaskTimeout, TimeUnit clusterDataTaskTimeoutUnit) {
        this.setClusterDataTaskTimeout(clusterDataTaskTimeout);
        this.setClusterDataTaskTimeoutUnit(clusterDataTaskTimeoutUnit);
    }

    protected void doStop() throws Exception {
        super.doStop();
        CamelContext context = this.getCamelContext();
        if (this.executor != null) {
            if (context != null) {
                context.getExecutorServiceManager().shutdown((ExecutorService)this.executor);
            } else {
                this.executor.shutdown();
            }
            this.executor = null;
        }
        if (this.clusterDataTaskExecutor != null) {
            if (context != null) {
                context.getExecutorServiceManager().shutdown(this.clusterDataTaskExecutor);
            } else {
                this.clusterDataTaskExecutor.shutdown();
            }
        }
    }

    ScheduledExecutorService getExecutor() {
        Lock internalLock = this.getInternalLock();
        internalLock.lock();
        try {
            if (this.executor == null) {
                CamelContext context = (CamelContext)ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
                this.executor = context.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "FileLockClusterService-" + this.getId());
            }
            ScheduledExecutorService scheduledExecutorService = this.executor;
            return scheduledExecutorService;
        }
        finally {
            internalLock.unlock();
        }
    }

    ExecutorService getClusterDataTaskExecutor() {
        Lock internalLock = this.getInternalLock();
        internalLock.lock();
        try {
            if (this.clusterDataTaskExecutor == null) {
                CamelContext context = (CamelContext)ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext");
                this.clusterDataTaskExecutor = context.getExecutorServiceManager().newFixedThreadPool((Object)this, "FileLockClusterDataTask-" + this.getId(), 5);
            }
            ExecutorService executorService = this.clusterDataTaskExecutor;
            return executorService;
        }
        finally {
            internalLock.unlock();
        }
    }
}

