/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.PollDynamicAware;
import org.apache.camel.support.component.PollDynamicAwareSupport;
import org.apache.camel.util.URISupport;

public abstract class GenericFilePollDynamicAware
extends PollDynamicAwareSupport {
    public static final String PROP_FILE_NAME = "fileName";

    public boolean isLenientProperties() {
        return false;
    }

    public PollDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map properties = this.endpointProperties(exchange, uri);
        return new PollDynamicAware.DynamicAwareEntry(uri, originalUri, properties, null);
    }

    public String resolveStaticUri(Exchange exchange, PollDynamicAware.DynamicAwareEntry entry) throws Exception {
        String uri = entry.getUri();
        uri = uri.replace("\t", "\\\\t");
        boolean fileName = entry.getProperties().containsKey(PROP_FILE_NAME);
        if (fileName) {
            Map params = entry.getProperties();
            Map originalParams = URISupport.parseQuery((String)URISupport.extractQuery((String)entry.getOriginalUri()));
            GenericFilePollDynamicAware.compute(originalParams, PROP_FILE_NAME, params);
            return this.asEndpointUri(exchange, uri, params);
        }
        return uri;
    }

    private static void compute(Map<String, Object> originalParams, String propFileName, Map<String, Object> params) {
        Object val = originalParams.get(propFileName);
        if (val != null) {
            params.put(propFileName, val.toString());
        }
    }
}

