/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class GenericFileConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
        this.registerFallbackConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        GenericFileConverterLoader.addTypeConverter(registry, InputStream.class, GenericFile.class, false, (type, exchange, value) -> {
            InputStream answer = GenericFileConverter.genericFileToInputStream((GenericFile)value, exchange);
            return answer;
        });
        GenericFileConverterLoader.addTypeConverter(registry, Reader.class, GenericFile.class, false, (type, exchange, value) -> {
            Reader answer = GenericFileConverter.genericFileToReader((GenericFile)value, exchange);
            return answer;
        });
        GenericFileConverterLoader.addTypeConverter(registry, Serializable.class, GenericFile.class, false, (type, exchange, value) -> {
            Serializable answer = GenericFileConverter.genericFileToSerializable((GenericFile)value, exchange);
            return answer;
        });
        GenericFileConverterLoader.addTypeConverter(registry, String.class, GenericFile.class, false, (type, exchange, value) -> {
            String answer = GenericFileConverter.genericFileToString((GenericFile)value, exchange);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        GenericFileConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> GenericFileConverter.convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }
}

