/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.AbstractFileResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.DirectoryEntries;
import org.apache.camel.component.file.consumer.adapters.FileSet;

class DefaultDirectoryEntriesResumeAdapter
extends AbstractFileResumeAdapter
implements DirectoryEntriesResumeAdapter {
    private DirectoryEntries fileSet;

    DefaultDirectoryEntriesResumeAdapter() {
    }

    private boolean notProcessed(File directory, File file) {
        FileSet cached = (FileSet)this.cache.get((Object)directory, FileSet.class);
        if (cached == null) {
            return true;
        }
        return !cached.contains(file);
    }

    @Override
    public void setResumePayload(DirectoryEntries fileSet) {
        assert (fileSet != null);
        this.fileSet = fileSet;
    }

    @Override
    protected boolean add(Object key, Object offset) {
        if (!(offset instanceof File)) {
            throw new UnsupportedOperationException("This adapter cannot be used for file offsets");
        }
        FileSet fileSet = (FileSet)this.cache.computeIfAbsent((Object)((File)key), k -> new FileSet());
        fileSet.update((File)offset);
        return true;
    }

    private void resumeDirectoryEntries() {
        DirectoryEntries.doResume(this.fileSet, f -> this.notProcessed(this.fileSet.getDirectory(), (File)f));
    }

    public void resume() {
        this.resumeDirectoryEntries();
    }

    public void deserializeFileEntry(File keyObj, File valueObj) {
        FileSet fileSet = (FileSet)this.cache.computeIfAbsent((Object)keyObj, obj -> new FileSet());
        fileSet.update(valueObj);
    }
}

