/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.SyntheticAnnotated;

@Vetoed
class SyntheticBeanAttributes<T> {
    private final BeanManager manager;
    private final SyntheticAnnotated annotated;

    SyntheticBeanAttributes(BeanManager manager, SyntheticAnnotated annotated) {
        this.manager = manager;
        this.annotated = annotated;
    }

    <A extends Annotation> void addQualifier(A qualifier) {
        this.annotated.addAnnotation(qualifier);
    }

    public Class<? extends Annotation> getScope() {
        return this.annotated.getAnnotations().stream().map(Annotation::annotationType).filter(arg_0 -> ((BeanManager)this.manager).isScope(arg_0)).findAny().orElse(Dependent.class);
    }

    public Set<Annotation> getQualifiers() {
        return this.annotated.getAnnotations().stream().filter(a -> this.manager.isQualifier(a.annotationType())).collect(Collectors.toSet());
    }

    public String getName() {
        return this.annotated.getAnnotations().stream().filter(CdiSpiHelper.isAnnotationType(Named.class)).map(Named.class::cast).map(Named::value).findFirst().orElse(null);
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.annotated.getTypeClosure();
    }

    public boolean isAlternative() {
        return false;
    }
}

