/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;

@org.apache.camel.spi.annotations.Component(value="bean")
public class BeanComponent
extends DefaultComponent {
    private final Map<BeanInfoCacheKey, BeanInfo> beanInfoCache = LRUCacheFactory.newLRUSoftCache((int)1000);
    @Metadata(label="advanced", description="If enabled, Camel will cache the result of the first Registry look-up. Cache can be enabled if the bean in the Registry is defined as a singleton scope.")
    private Boolean cache;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanEndpoint endpoint = new BeanEndpoint(uri, (Component)this);
        endpoint.setBeanName(remaining);
        endpoint.setCache(this.cache);
        this.setProperties((Object)endpoint, parameters);
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"bean.");
        endpoint.setParameters(options);
        return endpoint;
    }

    BeanInfo getBeanInfoFromCache(BeanInfoCacheKey key) {
        return this.beanInfoCache.get(key);
    }

    void addBeanInfoToCache(BeanInfoCacheKey key, BeanInfo beanInfo) {
        this.beanInfoCache.put(key, beanInfo);
    }

    protected void doShutdown() throws Exception {
        if (this.log.isDebugEnabled() && this.beanInfoCache instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.beanInfoCache;
            this.log.debug("Clearing BeanInfo cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
        }
        this.beanInfoCache.clear();
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }
}

