/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.AbstractLocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;

public class FilePropertiesSource
extends AbstractLocationPropertiesSource
implements Ordered {
    private final int order;

    protected FilePropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        this(propertiesComponent, location, 300);
    }

    protected FilePropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location, int order) {
        super(propertiesComponent, location);
        this.order = order;
    }

    public String getName() {
        return "FilePropertiesSource[" + this.getLocation().getPath() + "]";
    }

    @Override
    public Properties loadPropertiesFromLocation(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        OrderedProperties answer = new OrderedProperties();
        String path = location.getPath();
        BufferedReader reader = null;
        try (FileInputStream is = new FileInputStream(path);){
            if (propertiesComponent.getEncoding() != null) {
                reader = new BufferedReader(new InputStreamReader((InputStream)is, propertiesComponent.getEncoding()));
                answer.load(reader);
            } else {
                answer.load(is);
            }
        }
        catch (FileNotFoundException e) {
            if (!propertiesComponent.isIgnoreMissingLocation() && !location.isOptional()) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        catch (IOException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            IOHelper.close(reader);
        }
        return answer;
    }

    public int getOrder() {
        return this.order;
    }
}

