/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.spi.Language;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

public final class AWS2S3Utils {
    private AWS2S3Utils() {
    }

    public static String determineBucketName(Exchange exchange, AWS2S3Configuration configuration) {
        String bucketName = (String)exchange.getIn().getHeader("CamelAwsS3BucketName", String.class);
        if (ObjectHelper.isEmpty((String)bucketName)) {
            bucketName = configuration.getBucketName();
        }
        if (bucketName == null) {
            throw new IllegalArgumentException("AWS S3 Bucket name header is missing or not configured.");
        }
        if (LanguageSupport.hasSimpleFunction((String)bucketName)) {
            Language simple = exchange.getContext().resolveLanguage("simple");
            bucketName = (String)simple.createExpression(bucketName).evaluate(exchange, String.class);
        }
        return bucketName;
    }

    public static String determineStorageClass(Exchange exchange, AWS2S3Configuration configuration) {
        String storageClass = (String)exchange.getIn().getHeader("CamelAwsS3StorageClass", String.class);
        if (storageClass == null) {
            storageClass = configuration.getStorageClass();
        }
        return storageClass;
    }

    public static String determineFileExtension(String keyName) {
        int extPosition = keyName.lastIndexOf(".");
        if (extPosition == -1) {
            return "";
        }
        return keyName.substring(extPosition);
    }

    public static String determineFileName(String keyName) {
        int extPosition = keyName.lastIndexOf(".");
        if (extPosition == -1) {
            return keyName;
        }
        return keyName.substring(0, extPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long determineLengthInputStream(InputStream is) throws IOException {
        long len;
        if (is instanceof StreamCache && (len = ((StreamCache)is).length()) > 0L) {
            return len;
        }
        if (!is.markSupported()) {
            return -1L;
        }
        if (is instanceof ByteArrayInputStream) {
            return is.available();
        }
        long size = 0L;
        try {
            is.mark(1024);
            int i = is.available();
            while (i > 0) {
                long skip = is.skip(i);
                size += skip;
                i = is.available();
            }
        }
        finally {
            is.reset();
        }
        return size;
    }

    public static byte[] toByteArray(InputStream is, int size) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] data = new byte[4096];
            int n = 0;
            for (int total = 0; total < size && (n = is.read(data)) != -1; total += n) {
                output.write(data, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String determineKey(Exchange exchange, AWS2S3Configuration configuration) {
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (ObjectHelper.isEmpty((String)key)) {
            key = configuration.getKeyName();
        }
        if (key == null) {
            throw new IllegalArgumentException("AWS S3 Key header missing.");
        }
        if (LanguageSupport.hasSimpleFunction((String)key)) {
            Language simple = exchange.getContext().resolveLanguage("simple");
            key = (String)simple.createExpression(key).evaluate(exchange, String.class);
        }
        return key;
    }

    public static void setEncryption(CreateMultipartUploadRequest.Builder createMultipartUploadRequest, AWS2S3Configuration configuration) {
        if (configuration.isUseAwsKMS()) {
            createMultipartUploadRequest.ssekmsKeyId(configuration.getAwsKMSKeyId());
            createMultipartUploadRequest.serverSideEncryption(ServerSideEncryption.AWS_KMS);
        }
        if (configuration.isUseSSES3()) {
            createMultipartUploadRequest.serverSideEncryption(ServerSideEncryption.AES256);
        }
        if (configuration.isUseCustomerKey()) {
            if (ObjectHelper.isNotEmpty((String)configuration.getCustomerKeyId())) {
                createMultipartUploadRequest.sseCustomerKey(configuration.getCustomerKeyId());
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getCustomerKeyMD5())) {
                createMultipartUploadRequest.sseCustomerKeyMD5(configuration.getCustomerKeyMD5());
            }
            if (ObjectHelper.isNotEmpty((String)configuration.getCustomerAlgorithm())) {
                createMultipartUploadRequest.sseCustomerAlgorithm(configuration.getCustomerAlgorithm());
            }
        }
    }
}

