/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.Ordered;
import org.apache.camel.spi.HasGroup;
import org.apache.camel.spi.HasId;

public interface HealthCheck
extends HasGroup,
HasId,
Ordered {
    public static final String CHECK_ID = "check.id";
    public static final String CHECK_GROUP = "check.group";
    public static final String CHECK_KIND = "check.kind";
    public static final String CHECK_ENABLED = "check.enabled";
    public static final String INVOCATION_COUNT = "invocation.count";
    public static final String INVOCATION_TIME = "invocation.time";
    @Deprecated
    public static final String INVOCATION_ATTEMPT_TIME = "invocation.attempt.time";
    public static final String FAILURE_COUNT = "failure.count";
    public static final String FAILURE_START_TIME = "failure.start.time";
    public static final String FAILURE_TIME = "failure.time";
    public static final String FAILURE_ERROR_COUNT = "failure.error.count";
    public static final String ENDPOINT_URI = "endpoint.uri";
    public static final String SUCCESS_COUNT = "success.count";
    public static final String SUCCESS_START_TIME = "success.start.time";
    public static final String SUCCESS_TIME = "success.time";
    public static final String HTTP_RESPONSE_CODE = "http.response.code";
    @Deprecated
    public static final String FAILURE_ENDPOINT_URI = "failure.endpoint.uri";

    @Override
    default public int getOrder() {
        return 2147482647;
    }

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    default public Map<String, Object> getMetaData() {
        return Collections.emptyMap();
    }

    default public boolean isReadiness() {
        return true;
    }

    default public boolean isLiveness() {
        return true;
    }

    default public Result call() {
        return this.call(Collections.emptyMap());
    }

    default public Result callReadiness() {
        return this.call(Map.of(CHECK_KIND, Kind.READINESS));
    }

    default public Result callLiveness() {
        return this.call(Map.of(CHECK_KIND, Kind.LIVENESS));
    }

    public Result call(Map<String, Object> var1);

    public static interface Result {
        public HealthCheck getCheck();

        public State getState();

        public Optional<String> getMessage();

        public Optional<Throwable> getError();

        public Map<String, Object> getDetails();
    }

    public static enum Kind {
        READINESS,
        LIVENESS,
        ALL;

    }

    public static enum State {
        UP,
        DOWN,
        UNKNOWN;

    }
}

