/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ConnectionAbstract
extends InputAbstract {
    @Option(name={"--url"}, description="URL towards the broker. (default: Build URL from acceptors defined in the broker.xml or tcp://localhost:61616 if the default cannot be parsed)")
    protected String brokerURL = "tcp://localhost:61616";
    @Option(name={"--acceptor"}, description="Acceptor used to build URL towards the broker")
    protected String acceptor;
    @Option(name={"--user"}, description="User used to connect")
    protected String user;
    @Option(name={"--password"}, description="Password used to connect")
    protected String password;
    @Option(name={"--clientID"}, description="ClientID to be associated with connection")
    protected String clientID;
    @Option(name={"--protocol"}, description="Protocol used. Valid values are amqp or core. Default=core.")
    protected String protocol = "core";

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public String getAcceptor() {
        return this.acceptor;
    }

    public ConnectionAbstract setAcceptor(String acceptor) {
        this.acceptor = acceptor;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ConnectionAbstract setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionAbstract setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public ConnectionAbstract setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        String brokerURLInstance;
        super.execute(context);
        if (this.brokerURL == "tcp://localhost:61616" && (brokerURLInstance = this.getBrokerURLInstance(this.acceptor)) != null) {
            this.brokerURL = brokerURLInstance;
        }
        context.out.println("Connection brokerURL = " + this.brokerURL);
        return null;
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return this.createConnectionFactory(this.brokerURL, this.user, this.password, this.clientID, this.protocol);
    }

    protected ConnectionFactory createConnectionFactory(String brokerURL, String user, String password, String clientID, String protocol) throws Exception {
        if (protocol.equals("core")) {
            return this.createCoreConnectionFactory(brokerURL, user, password, clientID);
        }
        if (protocol.equals("amqp")) {
            return this.createAMQPConnectionFactory(brokerURL, user, password, clientID);
        }
        throw new IllegalStateException("protocol " + protocol + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("tcp://")) {
            brokerURL = "amqp" + ((String)brokerURL).substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(user, password, (String)brokerURL);
        if (clientID != null) {
            cf.setClientID(clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            cf = new JmsConnectionFactory(this.inputUser(user), this.inputPassword(password), (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            cf = new JmsConnectionFactory(this.inputUser(user), this.inputPassword(password), this.inputBrokerURL((String)brokerURL));
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory() {
        return this.createCoreConnectionFactory(this.brokerURL, this.user, this.password, this.clientID);
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory(String brokerURL, String user, String password, String clientID) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerURL, user, password);
        if (clientID != null) {
            this.getActionContext().out.println("Consumer:: clientID = " + clientID);
            cf.setClientID(clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            cf = new ActiveMQConnectionFactory(brokerURL, this.inputUser(user), this.inputPassword(password));
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            cf = new ActiveMQConnectionFactory(this.inputBrokerURL(brokerURL), this.inputUser(user), this.inputPassword(password));
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
    }

    private String inputBrokerURL(String defaultValue) {
        return this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", defaultValue);
    }

    private String inputUser(String user) {
        if (user == null) {
            this.user = this.input("--user", "Type the username for a retry", null);
            return this.user;
        }
        return user;
    }

    private String inputPassword(String password) {
        if (password == null) {
            this.password = this.inputPassword("--password", "Type the password for a retry", null);
            return this.password;
        }
        return password;
    }
}

