/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.Route;
import org.apache.camel.impl.event.AbstractRouteEvent;
import org.apache.camel.spi.CamelEvent;

public class RouteRestartingFailureEvent
extends AbstractRouteEvent
implements CamelEvent.RouteRestartingFailureEvent {
    private static final long serialVersionUID = 1330257282431407331L;
    private final long attempt;
    private final Throwable cause;
    private final boolean exhausted;

    public RouteRestartingFailureEvent(Route source, long attempt, Throwable cause, boolean exhausted) {
        super(source);
        this.attempt = attempt;
        this.cause = cause;
        this.exhausted = exhausted;
    }

    public long getAttempt() {
        return this.attempt;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public String toString() {
        return "Route " + (this.attempt == 0L ? "starting " : "restarting ") + (this.exhausted ? "exhausted: " : "failed: ") + this.getRoute().getId() + " (attempt: " + this.attempt + ") due to " + this.cause.getMessage();
    }
}

