/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.server.core.restrictor.policy.AbstractChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MBeanNameFilter
extends AbstractChecker<ObjectName> {
    private final List<Function<ObjectName, Boolean>> filters = new ArrayList<Function<ObjectName, Boolean>>();

    public MBeanNameFilter(Document pDoc) {
        NodeList filteredNodes = pDoc.getElementsByTagName("filter");
        if (filteredNodes.getLength() > 0) {
            for (int i = 0; i < filteredNodes.getLength(); ++i) {
                Node filteredNode = filteredNodes.item(i);
                NodeList nodes = filteredNode.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node node = nodes.item(j);
                    if (node.getNodeType() != 1) continue;
                    this.assertNodeName(node, "mbean");
                    String pattern = node.getTextContent().trim();
                    Function<ObjectName, Boolean> matcher = this.createMatcher(pattern);
                    if (matcher == null) continue;
                    this.filters.add(matcher);
                }
            }
        }
    }

    @Override
    public boolean check(ObjectName pArg) {
        return !this.isObjectNameHidden(pArg);
    }

    public boolean isObjectNameHidden(ObjectName name) {
        boolean hidden = false;
        for (Function<ObjectName, Boolean> filter : this.filters) {
            if (!filter.apply(name).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Function<ObjectName, Boolean> createMatcher(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        if (!pattern.contains(":") || pattern.endsWith(":*") && pattern.indexOf(58) == pattern.length() - 2) {
            if (pattern.endsWith(":*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            return this.createDomainMatcher(pattern.trim());
        }
        try {
            ObjectName patternName = new ObjectName(pattern.trim());
            ArrayList<Function<ObjectName, Boolean>> filters = new ArrayList<Function<ObjectName, Boolean>>();
            filters.add(this.createDomainMatcher(patternName.getDomain()));
            patternName.getKeyPropertyList().forEach((k, v) -> filters.add(this.createPropertyMatcher((String)k, (String)v)));
            return new ComplexMatcher(filters);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid MBean name filter: \"" + pattern + "\"", e);
        }
    }

    private DomainMatcher createDomainMatcher(String pattern) {
        this.validateSingleGlob(pattern);
        if (pattern.contains("*")) {
            String[] parts = pattern.split("\\*");
            String prefix = parts[0].isEmpty() ? null : parts[0];
            String suffix = parts.length == 1 || parts[1].isEmpty() ? null : parts[1];
            return new DomainMatcher(prefix, suffix);
        }
        return new DomainMatcher(pattern);
    }

    private Function<ObjectName, Boolean> createPropertyMatcher(String key, String pattern) {
        if (key == null || key.contains("*")) {
            throw new IllegalArgumentException("Key can't contain wildcard: \"" + key + "\"");
        }
        this.validateSingleGlob(pattern);
        if (pattern.contains("*")) {
            String[] parts = pattern.split("\\*");
            String prefix = parts.length == 0 || parts[0].isEmpty() ? null : parts[0];
            String suffix = parts.length <= 1 || parts[1].isEmpty() ? null : parts[1];
            return new PropertyMatcher(key, prefix, suffix);
        }
        return new PropertyMatcher(key, pattern);
    }

    private void validateSingleGlob(String pattern) {
        if (pattern.indexOf(42) != pattern.lastIndexOf(42)) {
            throw new IllegalArgumentException("Can't use multiple Glob patterns: \"" + pattern + "\"");
        }
    }

    private static class DomainMatcher
    implements Function<ObjectName, Boolean> {
        private final String domain;
        private final String prefix;
        private final String suffix;

        public DomainMatcher(String pattern) {
            this.domain = pattern;
            this.prefix = null;
            this.suffix = null;
        }

        public DomainMatcher(String prefix, String suffix) {
            this.domain = null;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public Boolean apply(ObjectName objectName) {
            String d = objectName.getDomain();
            if (this.domain != null) {
                return d.equals(this.domain);
            }
            return !(this.prefix != null && !d.startsWith(this.prefix) || this.suffix != null && !d.endsWith(this.suffix));
        }
    }

    private static class ComplexMatcher
    implements Function<ObjectName, Boolean> {
        private final List<Function<ObjectName, Boolean>> filters;

        public ComplexMatcher(List<Function<ObjectName, Boolean>> filters) {
            this.filters = filters;
        }

        @Override
        public Boolean apply(ObjectName objectName) {
            boolean match = true;
            for (Function<ObjectName, Boolean> filter : this.filters) {
                match &= filter.apply(objectName).booleanValue();
            }
            return match;
        }
    }

    private static class PropertyMatcher
    implements Function<ObjectName, Boolean> {
        private final String key;
        private final String value;
        private final String prefix;
        private final String suffix;

        public PropertyMatcher(String key, String value) {
            this.key = key;
            this.value = value;
            this.prefix = null;
            this.suffix = null;
        }

        public PropertyMatcher(String key, String prefix, String suffix) {
            this.key = key;
            this.value = null;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public Boolean apply(ObjectName objectName) {
            String propertyValue = objectName.getKeyProperty(this.key);
            if (propertyValue == null) {
                return false;
            }
            if (this.value != null) {
                return propertyValue.equals(this.value);
            }
            return !(this.prefix != null && !propertyValue.startsWith(this.prefix) || this.suffix != null && !propertyValue.endsWith(this.suffix));
        }
    }
}

