/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.TextMessage;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.web.WebClient;
import org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageServletSupport
extends HttpServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(MessageServletSupport.class);
    private static final String MAX_MESSAGE_SIZE_TAG = "maxMessageSize";
    private static final Long DEFAULT_MAX_MESSAGE_SIZE = 100000L;
    private boolean defaultTopicFlag = true;
    private Destination defaultDestination;
    private String destinationParameter = "destination";
    private String typeParameter = "type";
    private String bodyParameter = "body";
    private boolean defaultMessagePersistent = true;
    private int defaultMessagePriority = 5;
    private long defaultMessageTimeToLive;
    private String destinationOptions;
    private long maxMessageSize = DEFAULT_MAX_MESSAGE_SIZE;

    public void init(ServletConfig servletConfig) throws ServletException {
        String maxMessageSizeConfigured;
        super.init(servletConfig);
        this.destinationOptions = servletConfig.getInitParameter("destinationOptions");
        String name = servletConfig.getInitParameter("topic");
        if (name != null) {
            this.defaultTopicFlag = MessageServletSupport.asBoolean(name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Defaulting to use topics: " + this.defaultTopicFlag);
        }
        if ((name = servletConfig.getInitParameter("destination")) != null) {
            this.defaultDestination = this.defaultTopicFlag ? new ActiveMQTopic(name) : new ActiveMQQueue(name);
        }
        if ((maxMessageSizeConfigured = servletConfig.getInitParameter(MAX_MESSAGE_SIZE_TAG)) != null) {
            this.maxMessageSize = Long.parseLong(maxMessageSizeConfigured);
        }
        WebClient.initContext(this.getServletContext());
    }

    public static boolean asBoolean(String param) {
        return MessageServletSupport.asBoolean(param, false);
    }

    public static boolean asBoolean(String param, boolean defaultValue) {
        if (param == null) {
            return defaultValue;
        }
        return param.equalsIgnoreCase("true");
    }

    protected void appendParametersToMessage(HttpServletRequest request, TextMessage message) throws JMSException {
        String type;
        Destination replyTo;
        Long expiration;
        Map parameterMap = request.getParameterMap();
        if (parameterMap == null) {
            return;
        }
        HashMap parameters = new HashMap(parameterMap);
        String correlationID = this.asString(parameters.remove("JMSCorrelationID"));
        if (correlationID != null) {
            message.setJMSCorrelationID(correlationID);
        }
        if ((expiration = this.asLong(parameters.remove("JMSExpiration"))) != null) {
            message.setJMSExpiration(expiration.longValue());
        }
        if ((replyTo = this.asDestination(parameters.remove("JMSReplyTo"))) != null) {
            message.setJMSReplyTo(replyTo);
        }
        if ((type = this.asString(parameters.remove("JMSType"))) != null) {
            message.setJMSType(type);
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            if (this.destinationParameter.equals(name) || this.typeParameter.equals(name) || this.bodyParameter.equals(name) || "JMSDeliveryMode".equals(name) || "JMSPriority".equals(name) || "JMSTimeToLive".equals(name)) continue;
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length == 1) {
                    value = array[0];
                } else {
                    LOG.warn("Can't use property: " + name + " which is of type: " + value.getClass().getName() + " value");
                    value = null;
                    int size = array.length;
                    for (int i = 0; i < size; ++i) {
                        LOG.debug("value[" + i + "] = " + array[i]);
                    }
                }
            }
            if (value == null) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected long getSendTimeToLive(HttpServletRequest request) {
        String text = request.getParameter("JMSTimeToLive");
        if (text != null) {
            return this.asLong(text);
        }
        return this.defaultMessageTimeToLive;
    }

    protected int getSendPriority(HttpServletRequest request) {
        String text = request.getParameter("JMSPriority");
        if (text != null) {
            return this.asInt(text);
        }
        return this.defaultMessagePriority;
    }

    protected boolean isSendPersistent(HttpServletRequest request) {
        String text = request.getParameter("JMSDeliveryMode");
        if (text != null) {
            return text.trim().equalsIgnoreCase("persistent");
        }
        return this.defaultMessagePersistent;
    }

    protected boolean isSync(HttpServletRequest request) {
        String text = request.getParameter("sync");
        return text != null;
    }

    protected Destination asDestination(Object value) {
        if (value instanceof Destination) {
            return (Destination)value;
        }
        if (value instanceof String) {
            String text = (String)value;
            return ActiveMQDestination.createDestination((String)text, (byte)1);
        }
        if (value instanceof String[]) {
            String text = ((String[])value)[0];
            if (text == null) {
                return null;
            }
            return ActiveMQDestination.createDestination((String)text, (byte)1);
        }
        return null;
    }

    protected Integer asInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Integer.valueOf(((String[])value)[0]);
        }
        return null;
    }

    protected Long asLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Long.valueOf(((String[])value)[0]);
        }
        return null;
    }

    protected long asLong(String name) {
        return Long.parseLong(name);
    }

    protected int asInt(String name) {
        return Integer.parseInt(name);
    }

    protected String asString(Object value) {
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request) throws JMSException {
        String destinationName = request.getParameter(this.destinationParameter);
        if (destinationName == null || destinationName.equals("")) {
            if (this.defaultDestination == null) {
                return this.getDestinationFromURI(client, request);
            }
            return this.defaultDestination;
        }
        return this.getDestination(client, request, destinationName);
    }

    protected Destination getDestinationFromURI(WebClient client, HttpServletRequest request) throws JMSException {
        String uri = request.getPathInfo();
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("/") && (uri = uri.substring(1)).length() == 0) {
            return null;
        }
        uri = uri.replace('/', '.');
        LOG.debug("destination uri=" + uri);
        return this.getDestination(client, request, uri);
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request, String destinationName) throws JMSException {
        boolean isTopic = this.defaultTopicFlag;
        isTopic = ((String)destinationName).startsWith("topic://") ? true : (((String)destinationName).startsWith("channel://") || ((String)destinationName).startsWith("queue://") ? false : this.isTopic(request));
        if (((String)destinationName).indexOf("://") != -1) {
            destinationName = ((String)destinationName).substring(((String)destinationName).indexOf("://") + 3);
        }
        if (this.destinationOptions != null) {
            destinationName = (String)destinationName + "?" + this.destinationOptions;
        }
        LOG.debug((String)destinationName + " (" + (isTopic ? "topic" : "queue") + ")");
        if (isTopic) {
            return client.getSession().createTopic((String)destinationName);
        }
        return client.getSession().createQueue((String)destinationName);
    }

    protected boolean isTopic(HttpServletRequest request) {
        String typeText = request.getParameter(this.typeParameter);
        if (typeText == null) {
            return this.defaultTopicFlag;
        }
        return typeText.equalsIgnoreCase("topic");
    }

    protected String getPostedMessageBody(HttpServletRequest request) throws IOException {
        String answer = request.getParameter(this.bodyParameter);
        String contentType = request.getContentType();
        if (answer == null && contentType != null) {
            String line;
            LOG.debug("Content-Type={}", (Object)contentType);
            BoundedInputStream boundedInputStream = new BoundedInputStream((InputStream)request.getInputStream(), this.maxMessageSize);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)boundedInputStream));
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            return buffer.toString();
        }
        return answer;
    }

    protected String getSelector(HttpServletRequest request) throws IOException {
        return request.getHeader(WebClient.selectorName);
    }
}

