
package org.apache.activemq.schema.core;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy;
import org.jvnet.jaxb.lang.Equals;
import org.jvnet.jaxb.lang.EqualsStrategy;
import org.jvnet.jaxb.lang.HashCode;
import org.jvnet.jaxb.lang.HashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Classe Java pour anonymous complex type.
 * 
 * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="dropAll" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="dropOnly" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="dropTemporaryQueues" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="dropTemporaryTopics" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="reportInterval" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "discardingDLQBrokerPlugin")
public class DtoDiscardingDLQBrokerPlugin implements Equals, HashCode, ToString
{

    @XmlAttribute(name = "dropAll")
    protected Boolean dropAll;
    @XmlAttribute(name = "dropOnly")
    protected String dropOnly;
    @XmlAttribute(name = "dropTemporaryQueues")
    protected Boolean dropTemporaryQueues;
    @XmlAttribute(name = "dropTemporaryTopics")
    protected Boolean dropTemporaryTopics;
    @XmlAttribute(name = "reportInterval")
    protected BigInteger reportInterval;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Obtient la valeur de la propriété dropAll.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDropAll() {
        return dropAll;
    }

    /**
     * Définit la valeur de la propriété dropAll.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDropAll(Boolean value) {
        this.dropAll = value;
    }

    /**
     * Obtient la valeur de la propriété dropOnly.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDropOnly() {
        return dropOnly;
    }

    /**
     * Définit la valeur de la propriété dropOnly.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDropOnly(String value) {
        this.dropOnly = value;
    }

    /**
     * Obtient la valeur de la propriété dropTemporaryQueues.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDropTemporaryQueues() {
        return dropTemporaryQueues;
    }

    /**
     * Définit la valeur de la propriété dropTemporaryQueues.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDropTemporaryQueues(Boolean value) {
        this.dropTemporaryQueues = value;
    }

    /**
     * Obtient la valeur de la propriété dropTemporaryTopics.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDropTemporaryTopics() {
        return dropTemporaryTopics;
    }

    /**
     * Définit la valeur de la propriété dropTemporaryTopics.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDropTemporaryTopics(Boolean value) {
        this.dropTemporaryTopics = value;
    }

    /**
     * Obtient la valeur de la propriété reportInterval.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getReportInterval() {
        return reportInterval;
    }

    /**
     * Définit la valeur de la propriété reportInterval.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setReportInterval(BigInteger value) {
        this.reportInterval = value;
    }

    /**
     * Obtient la valeur de la propriété id.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Définit la valeur de la propriété id.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            Boolean theDropAll;
            theDropAll = this.isDropAll();
            strategy.appendField(locator, this, "dropAll", buffer, theDropAll, (this.dropAll!= null));
        }
        {
            String theDropOnly;
            theDropOnly = this.getDropOnly();
            strategy.appendField(locator, this, "dropOnly", buffer, theDropOnly, (this.dropOnly!= null));
        }
        {
            Boolean theDropTemporaryQueues;
            theDropTemporaryQueues = this.isDropTemporaryQueues();
            strategy.appendField(locator, this, "dropTemporaryQueues", buffer, theDropTemporaryQueues, (this.dropTemporaryQueues!= null));
        }
        {
            Boolean theDropTemporaryTopics;
            theDropTemporaryTopics = this.isDropTemporaryTopics();
            strategy.appendField(locator, this, "dropTemporaryTopics", buffer, theDropTemporaryTopics, (this.dropTemporaryTopics!= null));
        }
        {
            BigInteger theReportInterval;
            theReportInterval = this.getReportInterval();
            strategy.appendField(locator, this, "reportInterval", buffer, theReportInterval, (this.reportInterval!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            Boolean theDropAll;
            theDropAll = this.isDropAll();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dropAll", theDropAll), currentHashCode, theDropAll, (this.dropAll!= null));
        }
        {
            String theDropOnly;
            theDropOnly = this.getDropOnly();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dropOnly", theDropOnly), currentHashCode, theDropOnly, (this.dropOnly!= null));
        }
        {
            Boolean theDropTemporaryQueues;
            theDropTemporaryQueues = this.isDropTemporaryQueues();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dropTemporaryQueues", theDropTemporaryQueues), currentHashCode, theDropTemporaryQueues, (this.dropTemporaryQueues!= null));
        }
        {
            Boolean theDropTemporaryTopics;
            theDropTemporaryTopics = this.isDropTemporaryTopics();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "dropTemporaryTopics", theDropTemporaryTopics), currentHashCode, theDropTemporaryTopics, (this.dropTemporaryTopics!= null));
        }
        {
            BigInteger theReportInterval;
            theReportInterval = this.getReportInterval();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "reportInterval", theReportInterval), currentHashCode, theReportInterval, (this.reportInterval!= null));
        }
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId, (this.id!= null));
        }
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, strategy);
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DtoDiscardingDLQBrokerPlugin that = ((DtoDiscardingDLQBrokerPlugin) object);
        {
            Boolean lhsDropAll;
            lhsDropAll = this.isDropAll();
            Boolean rhsDropAll;
            rhsDropAll = that.isDropAll();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dropAll", lhsDropAll), LocatorUtils.property(thatLocator, "dropAll", rhsDropAll), lhsDropAll, rhsDropAll, (this.dropAll!= null), (that.dropAll!= null))) {
                return false;
            }
        }
        {
            String lhsDropOnly;
            lhsDropOnly = this.getDropOnly();
            String rhsDropOnly;
            rhsDropOnly = that.getDropOnly();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dropOnly", lhsDropOnly), LocatorUtils.property(thatLocator, "dropOnly", rhsDropOnly), lhsDropOnly, rhsDropOnly, (this.dropOnly!= null), (that.dropOnly!= null))) {
                return false;
            }
        }
        {
            Boolean lhsDropTemporaryQueues;
            lhsDropTemporaryQueues = this.isDropTemporaryQueues();
            Boolean rhsDropTemporaryQueues;
            rhsDropTemporaryQueues = that.isDropTemporaryQueues();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dropTemporaryQueues", lhsDropTemporaryQueues), LocatorUtils.property(thatLocator, "dropTemporaryQueues", rhsDropTemporaryQueues), lhsDropTemporaryQueues, rhsDropTemporaryQueues, (this.dropTemporaryQueues!= null), (that.dropTemporaryQueues!= null))) {
                return false;
            }
        }
        {
            Boolean lhsDropTemporaryTopics;
            lhsDropTemporaryTopics = this.isDropTemporaryTopics();
            Boolean rhsDropTemporaryTopics;
            rhsDropTemporaryTopics = that.isDropTemporaryTopics();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "dropTemporaryTopics", lhsDropTemporaryTopics), LocatorUtils.property(thatLocator, "dropTemporaryTopics", rhsDropTemporaryTopics), lhsDropTemporaryTopics, rhsDropTemporaryTopics, (this.dropTemporaryTopics!= null), (that.dropTemporaryTopics!= null))) {
                return false;
            }
        }
        {
            BigInteger lhsReportInterval;
            lhsReportInterval = this.getReportInterval();
            BigInteger rhsReportInterval;
            rhsReportInterval = that.getReportInterval();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "reportInterval", lhsReportInterval), LocatorUtils.property(thatLocator, "reportInterval", rhsReportInterval), lhsReportInterval, rhsReportInterval, (this.reportInterval!= null), (that.reportInterval!= null))) {
                return false;
            }
        }
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId, (this.id!= null), (that.id!= null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        final EqualsStrategy strategy = new ElementAwareEqualsStrategy();
        return equals(null, null, object, strategy);
    }

}
