/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.jms.ConnectionFactory;
import jakarta.transaction.TransactionManager;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.apache.activemq.pool.JcaPooledConnectionFactory;
import org.apache.activemq.pool.XaPooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class PooledConnectionFactoryBean
implements FactoryBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledConnectionFactoryBean.class);
    private PooledConnectionFactory pooledConnectionFactory;
    private ConnectionFactory connectionFactory;
    private int maxConnections = 1;
    private int maximumActive = 500;
    private Object transactionManager;
    private String resourceName;

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaximumActive() {
        return this.maximumActive;
    }

    public void setMaximumActive(int maximumActive) {
        this.maximumActive = maximumActive;
    }

    public Object getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(Object transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        PooledConnectionFactory f;
        if (this.pooledConnectionFactory == null && this.transactionManager != null && this.resourceName != null) {
            try {
                LOGGER.debug("Trying to build a JcaPooledConnectionFactory");
                f = new JcaPooledConnectionFactory();
                ((JcaPooledConnectionFactory)f).setName(this.resourceName);
                ((org.apache.activemq.jms.pool.XaPooledConnectionFactory)f).setTransactionManager((TransactionManager)this.transactionManager);
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActiveSessionPerConnection(this.maximumActive);
                ((org.apache.activemq.jms.pool.XaPooledConnectionFactory)f).setConnectionFactory(this.connectionFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug("Could not create JCA enabled connection factory: " + String.valueOf(t), t);
            }
        }
        if (this.pooledConnectionFactory == null && this.transactionManager != null) {
            try {
                LOGGER.debug("Trying to build a XaPooledConnectionFactory");
                f = new XaPooledConnectionFactory();
                ((org.apache.activemq.jms.pool.XaPooledConnectionFactory)f).setTransactionManager((TransactionManager)this.transactionManager);
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActiveSessionPerConnection(this.maximumActive);
                ((org.apache.activemq.jms.pool.XaPooledConnectionFactory)f).setConnectionFactory(this.connectionFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug("Could not create XA enabled connection factory: " + String.valueOf(t), t);
            }
        }
        if (this.pooledConnectionFactory == null) {
            try {
                LOGGER.debug("Trying to build a PooledConnectionFactory");
                f = new PooledConnectionFactory();
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActiveSessionPerConnection(this.maximumActive);
                f.setConnectionFactory(this.connectionFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug("Could not create pooled connection factory: " + String.valueOf(t), t);
            }
        }
        if (this.pooledConnectionFactory == null) {
            throw new IllegalStateException("Unable to create pooled connection factory.  Enable DEBUG log level for more informations");
        }
    }

    @PreDestroy
    private void preDestroy() {
        try {
            this.destroy();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() throws Exception {
        if (this.pooledConnectionFactory != null) {
            this.pooledConnectionFactory.stop();
            this.pooledConnectionFactory = null;
        }
    }

    public Object getObject() throws Exception {
        if (this.pooledConnectionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.pooledConnectionFactory;
    }

    public Class getObjectType() {
        return ConnectionFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

