/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

@ManagedResource(description="Managed Processor")
public class ManagedProcessor
extends ManagedPerformanceCounter
implements ManagedInstance,
ManagedProcessorMBean {
    private final CamelContext context;
    private final Processor processor;
    private final ProcessorDefinition<?> definition;
    private final String id;
    private Route route;

    public ManagedProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) {
        this.context = context;
        this.processor = processor;
        this.definition = definition;
        this.id = definition.idOrCreate(context.getNodeIdFactory());
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.All;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public Object getInstance() {
        return this.processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ProcessorDefinition<?> getDefinition() {
        return this.definition;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Integer getIndex() {
        return this.definition.getIndex();
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public String getState() {
        if (this.processor instanceof StatefulService) {
            ServiceStatus status2 = ((StatefulService)((Object)this.processor)).getStatus();
            return status2.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    @Override
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @Override
    public String getProcessorId() {
        return this.id;
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.startService(this.getProcessor());
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.stopService(this.getProcessor());
    }

    @Override
    public String informationJson() {
        return this.context.explainEipJson(this.id, true);
    }

    @Override
    public TabularData explain(boolean allOptions) {
        try {
            String json = this.context.explainEipJson(this.id, allOptions);
            List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainEipTabularType());
            for (Map<String, String> row : rows) {
                String name = row.get("name");
                String kind = row.get("kind");
                String label = row.get("label") != null ? row.get("label") : "";
                String type = row.get("type");
                String javaType = row.get("javaType");
                String deprecated = row.get("deprecated") != null ? row.get("deprecated") : "";
                String value = row.get("value") != null ? row.get("value") : "";
                String defaultValue = row.get("defaultValue") != null ? row.get("defaultValue") : "";
                String description = row.get("description") != null ? row.get("description") : "";
                CompositeType ct = CamelOpenMBeanTypes.explainEipsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "label", "type", "java type", "deprecated", "value", "default value", "description"}, new Object[]{name, kind, label, type, javaType, deprecated, value, defaultValue, description});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

