/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.sitemesh;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.Buffer;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.views.JspSupportServlet;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplyDecoratorBean
extends Component {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String name;
    private String page;
    private String contentType;
    private String encoding;

    public ApplyDecoratorBean(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack);
        this.request = request;
        this.response = response;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean start(Writer writer) {
        return true;
    }

    protected boolean end(Writer writer, String body, boolean popComponentStack) {
        try {
            this.endAllowingExceptionThrowing(writer, body);
        }
        catch (Exception e) {
            throw new WebWorkException("failed when trying to end the parsing of component [" + this + "]", e);
        }
        super.end(writer, body, popComponentStack);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endAllowingExceptionThrowing(Writer writer, String body) throws IOException, ServletException, TemplateException {
        if (JspSupportServlet.jspSupportServlet == null) {
            throw new IllegalStateException("JspSupportServlet needs to be configured and loaded on start up");
        }
        Page pageObject = null;
        pageObject = this.page == null ? this.parsePageObjectFromContent(body) : (this.page.startsWith("http://") || this.page.startsWith("https://") ? this.parsePageObjectFromAbsoluteUrl(this.page) : this.parsePageObjectFromRelativeUrlPath(this.page));
        Decorator decorator = this.getDecorator(this.request, this.name);
        Template template = this.getFreemarkerTemplate(decorator.getPage());
        SimpleHash model = this.createModel();
        model.put("page", (Object)pageObject);
        if (pageObject instanceof HTMLPage) {
            model.put("head", (Object)((HTMLPage)pageObject).getHead());
        }
        model.put("body", (Object)pageObject.getBody());
        model.put("title", (Object)pageObject.getTitle());
        model.put("page.properties", (Object)pageObject.getProperties());
        template.process((Object)model, writer);
    }

    protected Template getFreemarkerTemplate(String templatePath) throws IOException, TemplateException {
        FreemarkerManager freemarkerManager = FreemarkerManager.getInstance();
        Configuration configuration = freemarkerManager.getConfiguration(JspSupportServlet.jspSupportServlet.getServletContext());
        return configuration.getTemplate(templatePath);
    }

    protected Page parsePageObjectFromContent(String content) throws IOException {
        PageParser pageParser = this.getPageParser(this.contentType);
        return pageParser.parse(content.toCharArray());
    }

    protected Page parsePageObjectFromAbsoluteUrl(String absoluteUrl) throws IOException {
        StringBuffer content = new StringBuffer(1024);
        URL url = new URL(this.page);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        int read = -1;
        do {
            char[] buffer;
            if ((read = reader.read(buffer = new char[1024])) <= -1) continue;
            content.append(buffer, 0, read);
        } while (read != -1);
        PageParser pageParser = this.getPageParser(this.contentType);
        return pageParser.parse(content.toString().toCharArray());
    }

    protected Page parsePageObjectFromRelativeUrlPath(String relativeUrl) throws TemplateException, IOException {
        String fullPath = this.page;
        if (fullPath.length() > 0 && fullPath.charAt(0) != '/') {
            int dotdot;
            String thisPath = this.request.getServletPath();
            if (thisPath == null) {
                String requestURI = this.request.getRequestURI();
                thisPath = this.request.getPathInfo() != null ? requestURI.substring(0, requestURI.indexOf(this.request.getPathInfo())) : requestURI;
            }
            fullPath = thisPath.substring(0, thisPath.lastIndexOf(47) + 1) + fullPath;
            while ((dotdot = fullPath.indexOf("..")) > -1) {
                int prevSlash = fullPath.lastIndexOf(47, dotdot - 2);
                fullPath = fullPath.substring(0, prevSlash) + fullPath.substring(dotdot + 2);
            }
        }
        String string = this.contentType = this.contentType == null ? "text/html" : this.contentType;
        if (this.encoding != null) {
            this.contentType = this.contentType + ";charset=" + this.encoding;
        }
        Template decoratorTemplate = this.getFreemarkerTemplate(fullPath);
        Factory factory = this.getSitemeshFactory();
        Buffer buffer = new Buffer(factory, this.contentType, this.encoding);
        SimpleHash model = this.createModel();
        decoratorTemplate.process((Object)model, (Writer)buffer.getWriter());
        Page pageObject = buffer.parse();
        return pageObject;
    }

    protected Factory getSitemeshFactory() {
        ServletConfig servletConfig = JspSupportServlet.jspSupportServlet.getServletConfig();
        Config config = new Config(servletConfig);
        Factory factory = Factory.getInstance((Config)config);
        return factory;
    }

    protected PageParser getPageParser(String contentType) {
        Factory factory = this.getSitemeshFactory();
        return factory.getPageParser(contentType == null ? "text/html" : contentType);
    }

    protected Decorator getDecorator(HttpServletRequest request, String decoratorName) {
        return this.getSitemeshFactory().getDecoratorMapper().getNamedDecorator(request, decoratorName);
    }

    protected Locale deduceLocale(ActionInvocation invocation, Configuration configuration) {
        if (invocation.getAction() instanceof LocaleProvider) {
            return ((LocaleProvider)invocation.getAction()).getLocale();
        }
        return configuration.getLocale();
    }

    protected SimpleHash createModel() throws TemplateException {
        FreemarkerManager freemarkerManager = FreemarkerManager.getInstance();
        ActionInvocation invocation = ActionContext.getContext().getActionInvocation();
        ServletContext servletContext = JspSupportServlet.jspSupportServlet.getServletContext();
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        ObjectWrapper wrapper = freemarkerManager.getConfiguration(servletContext).getObjectWrapper();
        Object action = null;
        if (invocation != null) {
            action = invocation.getAction();
        }
        return freemarkerManager.buildTemplateModel(stack, action, servletContext, this.request, this.response, wrapper);
    }
}

