/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.validators;

import com.opensymphony.webwork.dispatcher.ApplicationMap;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.RequestMap;
import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.DefaultActionInvocation;
import com.opensymphony.xwork.DefaultActionProxy;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.ValidationAwareSupport;
import com.opensymphony.xwork.config.entities.ActionConfig;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;

public class DWRValidator {
    private static final Log LOG = LogFactory.getLog(DWRValidator.class);

    public ValidationAwareSupport doPost(String namespace, String action, Map params) throws Exception {
        WebContext webContext = WebContextFactory.get();
        HttpServletRequest req = webContext.getHttpServletRequest();
        ServletContext servletContext = webContext.getServletContext();
        HttpServletResponse res = webContext.getHttpServletResponse();
        HashMap requestParams = new HashMap(req.getParameterMap());
        if (params != null) {
            requestParams.putAll(params);
        } else {
            params = requestParams;
        }
        RequestMap requestMap = new RequestMap(req);
        SessionMap session = new SessionMap(req);
        ApplicationMap application = new ApplicationMap(servletContext);
        DispatcherUtils du = DispatcherUtils.getInstance();
        HashMap ctx = du.createContextMap(requestMap, params, session, application, req, res, servletContext);
        try {
            ValidatorActionProxy proxy = new ValidatorActionProxy(namespace, action, ctx);
            proxy.execute();
            Object a = proxy.getAction();
            if (a instanceof ValidationAware) {
                ValidationAware aware = (ValidationAware)a;
                ValidationAwareSupport vas = new ValidationAwareSupport();
                vas.setActionErrors(aware.getActionErrors());
                vas.setActionMessages(aware.getActionMessages());
                vas.setFieldErrors(aware.getFieldErrors());
                return vas;
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while trying to validate", (Throwable)e);
            return null;
        }
    }

    public static class ValidatorActionProxy
    extends DefaultActionProxy {
        protected ValidatorActionProxy(String namespace, String actionName, Map extraContext) throws Exception {
            super(namespace, actionName, extraContext, false, true);
        }

        protected void prepare() throws Exception {
            this.invocation = new ValidatorActionInvocation((ActionProxy)this, this.extraContext);
        }
    }

    public static class ValidatorActionInvocation
    extends DefaultActionInvocation {
        protected ValidatorActionInvocation(ActionProxy proxy, Map extraContext) throws Exception {
            super(proxy, extraContext, true);
        }

        protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
            return "none";
        }
    }
}

