/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.spring;

import com.opensymphony.xwork.spring.SpringProxyableObjectFactory;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SessionContextSpringProxyableObjectFactory
extends SpringProxyableObjectFactory {
    private static final Log log = LogFactory.getLog(SessionContextSpringProxyableObjectFactory.class);

    protected ApplicationContext getApplicationContext(Map context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting the session-scoped app context");
        }
        if (context == null) {
            return this.appContext;
        }
        Map session = (Map)context.get("com.opensymphony.xwork.ActionContext.session");
        if (session == null) {
            log.warn((Object)"There is no session map in the ActionContext.");
            return this.appContext;
        }
        ApplicationContext sessionContext = (ApplicationContext)session.get("com.opensymphony.webwork.spring.ApplicationContextSessionListener_APP_CONTEXT");
        if (sessionContext == null) {
            throw new IllegalStateException("There is no application context in the user's session.");
        }
        return sessionContext;
    }

    public Object buildBean(String beanName, Map extraContext) throws Exception {
        Object bean = super.buildBean(beanName, extraContext);
        AutowireCapableBeanFactory autoWiringBeanFactory = this.findAutoWiringBeanFactory(this.getApplicationContext(extraContext));
        return this.autoWireBean(bean, autoWiringBeanFactory);
    }
}

