/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.xwork.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionMapperFactory {
    protected static final Log LOG = LogFactory.getLog(ActionMapperFactory.class);
    private static final CopyOnWriteMap classMap = CopyOnWriteMap.newHashMap();

    public static ActionMapper getMapper() {
        String clazz = (String)Configuration.get("webwork.mapper.class");
        try {
            ActionMapper mapper = (ActionMapper)classMap.get((Object)clazz);
            if (mapper == null) {
                mapper = (ActionMapper)ObjectFactory.getObjectFactory().buildBean(clazz, null);
                classMap.put((Object)clazz, (Object)mapper);
            }
            return mapper;
        }
        catch (Exception e) {
            String msg = "Could not create ActionMapper: WebWork will *not* work!";
            LOG.fatal((Object)msg, (Throwable)e);
            throw new WebWorkException(msg, e);
        }
    }
}

